/*
 * Decompiled with CFR 0.152.
 */
package nostr.crypto.nip04;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import lombok.NonNull;
import nostr.util.NostrUtil;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.custom.sec.SecP256K1Curve;

public class EncryptedDirectMessage {
    public static String encrypt(@NonNull String message, byte[] senderPrivKey, byte[] rcptPubKey) throws InvalidAlgorithmParameterException, NoSuchPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, BadPaddingException, InvalidKeyException {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return EncryptedDirectMessage.encryptMessage(senderPrivKey, rcptPubKey, message);
    }

    public static String decryptMessage(byte[] senderPrivKey, @NonNull String encContent, byte[] rcptPubKey) throws InvalidAlgorithmParameterException, NoSuchPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, BadPaddingException, InvalidKeyException {
        if (encContent == null) {
            throw new NullPointerException("encContent is marked non-null but is null");
        }
        SecretKeySpec sharedSecret = EncryptedDirectMessage.getSharedSecretKeySpec(senderPrivKey, rcptPubKey);
        return EncryptedDirectMessage.decryptMessage(sharedSecret, encContent);
    }

    private static String decryptMessage(SecretKeySpec sharedSecretKey, String encodedMessage) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        String[] parts = encodedMessage.split("\\?iv=");
        Base64.Decoder Base64Decoder = Base64.getDecoder();
        byte[] encryptedMessage = Base64Decoder.decode(parts[0]);
        byte[] iv = Base64Decoder.decode(parts[1]);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        IvParameterSpec ivParamSpec = new IvParameterSpec(iv);
        cipher.init(2, (Key)sharedSecretKey, ivParamSpec);
        return new String(cipher.doFinal(encryptedMessage), StandardCharsets.UTF_8);
    }

    static String encryptMessage(byte[] senderPrivateKey, byte[] rcptPublicKey, String message) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        SecretKeySpec sharedSecretKey = EncryptedDirectMessage.getSharedSecretKeySpec(senderPrivateKey, rcptPublicKey);
        byte[] iv = NostrUtil.createRandomByteArray(16);
        IvParameterSpec ivParamSpec = new IvParameterSpec(iv);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(1, (Key)sharedSecretKey, ivParamSpec);
        byte[] msg = message.getBytes(StandardCharsets.UTF_8);
        byte[] encryptedMessage = cipher.doFinal(msg);
        Base64.Encoder Base64Encoder2 = Base64.getEncoder();
        byte[] encryptedMessage64 = Base64Encoder2.encode(encryptedMessage);
        byte[] iv64 = Base64Encoder2.encode(ivParamSpec.getIV());
        return new String(encryptedMessage64) + "?iv=" + new String(iv64);
    }

    private static SecretKeySpec getSharedSecretKeySpec(byte[] privateKey, byte[] publicKey) {
        String secKeyHex = NostrUtil.bytesToHex(privateKey);
        String pubKeyHex = NostrUtil.bytesToHex(publicKey);
        byte[] sharedPoint = EncryptedDirectMessage.getSharedSecret(secKeyHex, pubKeyHex);
        byte[] sharedX = Arrays.copyOfRange(sharedPoint, 1, 33);
        return new SecretKeySpec(sharedX, "AES");
    }

    private static byte[] getSharedSecret(String privateKeyHex, String publicKeyHex) {
        SecP256K1Curve curve = new SecP256K1Curve();
        ECPoint pubKeyPt = curve.decodePoint(NostrUtil.nip04PubKeyHexToBytes("02" + publicKeyHex));
        BigInteger tweakVal = new BigInteger(1, NostrUtil.hexToBytes(privateKeyHex));
        return pubKeyPt.multiply(tweakVal).getEncoded(true);
    }
}

