/*
 * Decompiled with CFR 0.152.
 */
package nostr.crypto.nip44;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import lombok.NonNull;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptedPayloads {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EncryptedPayloads.class);

    public static String encrypt(String plaintext, byte[] conversationKey, byte[] nonce) throws Exception {
        byte[][] keys2 = EncryptedPayloads.getMessageKeys(conversationKey, nonce);
        byte[] chachaKey = keys2[0];
        byte[] chachaNonce = keys2[1];
        byte[] hmacKey = keys2[2];
        byte[] padded = EncryptedPayloads.pad(plaintext);
        Cipher cipher = Cipher.getInstance("ChaCha20");
        cipher.init(1, (Key)new SecretKeySpec(chachaKey, "ChaCha20"), new IvParameterSpec(chachaNonce));
        byte[] ciphertext = cipher.doFinal(padded);
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec(hmacKey, "HmacSHA256"));
        mac.update(nonce);
        mac.update(ciphertext);
        byte[] hmac = mac.doFinal();
        ByteBuffer buffer = ByteBuffer.allocate(1 + nonce.length + ciphertext.length + hmac.length);
        buffer.put((byte)2);
        buffer.put(nonce);
        buffer.put(ciphertext);
        buffer.put(hmac);
        return Base64.getEncoder().encodeToString(buffer.array());
    }

    public static String decrypt(String payload, byte[] conversationKey) throws Exception {
        byte[][] decodedPayload = EncryptedPayloads.decodePayload(payload);
        byte[] nonce = decodedPayload[0];
        byte[] ciphertext = decodedPayload[1];
        byte[] mac = decodedPayload[2];
        byte[][] keys2 = EncryptedPayloads.getMessageKeys(conversationKey, nonce);
        byte[] chachaKey = keys2[0];
        byte[] chachaNonce = keys2[1];
        byte[] hmacKey = keys2[2];
        Mac hmac = Mac.getInstance("HmacSHA256");
        hmac.init(new SecretKeySpec(hmacKey, "HmacSHA256"));
        hmac.update(nonce);
        hmac.update(ciphertext);
        byte[] calculatedMac = hmac.doFinal();
        if (!MessageDigest.isEqual(calculatedMac, mac)) {
            log.debug("Calculated MAC {} does not match expected {}", (Object)Arrays.toString(calculatedMac), (Object)Arrays.toString(mac));
            throw new Exception("Invalid MAC");
        }
        Cipher cipher = Cipher.getInstance("ChaCha20");
        cipher.init(2, (Key)new SecretKeySpec(chachaKey, "ChaCha20"), new IvParameterSpec(chachaNonce));
        byte[] paddedPlaintext = cipher.doFinal(ciphertext);
        return EncryptedPayloads.unpad(paddedPlaintext);
    }

    public static byte[] getConversationKey(String privkeyA, String pubkeyB) throws NoSuchAlgorithmException, InvalidKeySpecException {
        ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec("secp256k1");
        ECDomainParameters domainParameters = new ECDomainParameters(ecSpec.getCurve(), ecSpec.getG(), ecSpec.getN(), ecSpec.getH(), ecSpec.getSeed());
        BigInteger d = new BigInteger(privkeyA, 16);
        ECPrivateKeyParameters privateKeyParameters = new ECPrivateKeyParameters(d, domainParameters);
        ECPoint Q = domainParameters.getCurve().decodePoint(EncryptedPayloads.hexStringToByteArray(pubkeyB));
        ECPublicKeyParameters publicKeyParameters = new ECPublicKeyParameters(Q, domainParameters);
        ECPoint pointQ = new FixedPointCombMultiplier().multiply(publicKeyParameters.getQ(), privateKeyParameters.getD());
        byte[] sharedX = pointQ.normalize().getAffineXCoord().getEncoded();
        char[] sharedXChars = new String(sharedX, StandardCharsets.UTF_8).toCharArray();
        PBEKeySpec keySpec = new PBEKeySpec(sharedXChars, "nip44-v2".getBytes(), 65536, 256);
        SecretKeyFactory factory2 = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        return factory2.generateSecret(keySpec).getEncoded();
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i2 = 0; i2 < len; i2 += 2) {
            data[i2 / 2] = (byte)((Character.digit(s.charAt(i2), 16) << 4) + Character.digit(s.charAt(i2 + 1), 16));
        }
        return data;
    }

    private static int calcPaddedLen(int unpaddedLen) {
        int nextPower = 1 << (int)Math.floor(Math.log(unpaddedLen - 1) / Math.log(2.0)) + 1;
        int chunk = nextPower <= 256 ? 32 : nextPower / 8;
        if (unpaddedLen <= 32) {
            return 32;
        }
        return chunk * ((int)Math.floor((double)(unpaddedLen - 1) / (double)chunk) + 1);
    }

    private static byte[] pad(String plaintext) throws Exception {
        byte[] unpadded = plaintext.getBytes(StandardCharsets.UTF_8);
        int unpaddedLen = unpadded.length;
        if (unpaddedLen < 1 || unpaddedLen > 65535) {
            throw new Exception("Invalid plaintext length");
        }
        byte[] prefix = ByteBuffer.allocate(2).putShort((short)unpaddedLen).array();
        byte[] suffix = new byte[EncryptedPayloads.calcPaddedLen(unpaddedLen) - unpaddedLen];
        return EncryptedPayloads.concat(prefix, unpadded, suffix);
    }

    private static String unpad(byte[] padded) throws Exception {
        ByteBuffer wrapped = ByteBuffer.wrap(padded, 0, 2);
        int unpaddedLen = Short.toUnsignedInt(wrapped.getShort());
        byte[] unpadded = Arrays.copyOfRange(padded, 2, 2 + unpaddedLen);
        if (unpaddedLen == 0 || unpadded.length != unpaddedLen || padded.length != 2 + EncryptedPayloads.calcPaddedLen(unpaddedLen)) {
            throw new Exception("Invalid padding");
        }
        return new String(unpadded, StandardCharsets.UTF_8);
    }

    private static byte[][] decodePayload(@NonNull String payload) throws Exception {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        int plen = payload.length();
        if (plen == 0 || payload.charAt(0) == '#') {
            throw new Exception("Unknown version");
        }
        if (plen < 132 || plen > 87472) {
            throw new Exception("Invalid payload size");
        }
        byte[] data = Base64.getDecoder().decode(payload);
        int dlen = data.length;
        if (dlen < 99 || dlen > 65603) {
            throw new Exception("Invalid data size");
        }
        byte vers = data[0];
        if (vers != 2) {
            throw new Exception("Unknown version " + vers);
        }
        byte[] nonce = Arrays.copyOfRange(data, 1, 33);
        byte[] ciphertext = Arrays.copyOfRange(data, 33, dlen - 32);
        byte[] mac = Arrays.copyOfRange(data, dlen - 32, dlen);
        return new byte[][]{nonce, ciphertext, mac};
    }

    private static byte[] hmacAad(byte[] key, byte[] message, byte[] aad) throws Exception {
        if (aad.length != 32) {
            throw new Exception("AAD associated data must be 32 bytes");
        }
        Mac mac = Mac.getInstance("HmacSHA256");
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, "HmacSHA256");
        mac.init(secretKeySpec);
        mac.update(aad);
        mac.update(message);
        return mac.doFinal();
    }

    public static byte[] hkdf_extract(byte[] IKM, byte[] salt) {
        HKDFBytesGenerator hkdf = new HKDFBytesGenerator(new SHA256Digest());
        hkdf.init(new HKDFParameters(IKM, salt, null));
        byte[] okm = new byte[32];
        hkdf.generateBytes(okm, 0, okm.length);
        return okm;
    }

    private static byte[][] getMessageKeys(byte[] conversationKey, byte[] nonce) throws Exception {
        if (conversationKey.length != 32) {
            throw new Exception("Invalid conversation_key length");
        }
        if (nonce.length != 32) {
            throw new Exception("Invalid nonce length");
        }
        SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec spec = new PBEKeySpec(new String(conversationKey, StandardCharsets.UTF_8).toCharArray(), nonce, 65536, 608);
        byte[] keys2 = skf.generateSecret(spec).getEncoded();
        byte[] chachaKey = Arrays.copyOfRange(keys2, 0, 32);
        byte[] chachaNonce = Arrays.copyOfRange(keys2, 32, 44);
        byte[] hmacKey = Arrays.copyOfRange(keys2, 44, keys2.length);
        return new byte[][]{chachaKey, chachaNonce, hmacKey};
    }

    private static byte[] concat(byte[] ... arrays) {
        int totalLength = Arrays.stream(arrays).mapToInt(a -> ((byte[])a).length).sum();
        byte[] result = new byte[totalLength];
        int currentPosition = 0;
        for (byte[] array : arrays) {
            System.arraycopy(array, 0, result, currentPosition, array.length);
            currentPosition += array.length;
        }
        return result;
    }

    private static class Constants {
        public static final int MIN_PLAINTEXT_SIZE = 1;
        public static final int MAX_PLAINTEXT_SIZE = 65535;
        public static final String SALT_PREFIX = "nip44-v2";
        private static final String ENCRYPTION_ALGORITHM = "ChaCha20";
        private static final String HMAC_ALGORITHM = "HmacSHA256";
        private static final String KEY_DERIVATION_ALGORITHM = "PBKDF2WithHmacSHA256";
        private static final int CONVERSATION_KEY_LENGTH = 32;
        private static final int NONCE_LENGTH = 32;
        private static final int HMAC_KEY_LENGTH = 32;
        private static final int CHACHA_KEY_LENGTH = 32;
        private static final int CHACHA_NONCE_LENGTH = 12;
        private static final int VERSION = 2;

        private Constants() {
        }
    }
}

