/*
 * Decompiled with CFR 0.152.
 */
package nostr.encryption;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import lombok.Generated;
import lombok.NonNull;
import nostr.crypto.nip04.EncryptedDirectMessage;
import nostr.encryption.MessageCipher;

public class MessageCipher04
implements MessageCipher {
    private final byte[] senderPrivateKey;
    private final byte[] recipientPublicKey;

    @Override
    public String encrypt(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        try {
            return EncryptedDirectMessage.encrypt(message, this.senderPrivateKey, this.recipientPublicKey);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String decrypt(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        try {
            return EncryptedDirectMessage.decryptMessage(this.senderPrivateKey, message, this.recipientPublicKey);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    @Generated
    public byte[] getSenderPrivateKey() {
        return this.senderPrivateKey;
    }

    @Generated
    public byte[] getRecipientPublicKey() {
        return this.recipientPublicKey;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageCipher04)) {
            return false;
        }
        MessageCipher04 other = (MessageCipher04)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getSenderPrivateKey(), other.getSenderPrivateKey())) {
            return false;
        }
        return Arrays.equals(this.getRecipientPublicKey(), other.getRecipientPublicKey());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MessageCipher04;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getSenderPrivateKey());
        result = result * 59 + Arrays.hashCode(this.getRecipientPublicKey());
        return result;
    }

    @Generated
    public String toString() {
        return "MessageCipher04(senderPrivateKey=" + Arrays.toString(this.getSenderPrivateKey()) + ", recipientPublicKey=" + Arrays.toString(this.getRecipientPublicKey()) + ")";
    }

    @Generated
    public MessageCipher04(byte[] senderPrivateKey, byte[] recipientPublicKey) {
        this.senderPrivateKey = senderPrivateKey;
        this.recipientPublicKey = recipientPublicKey;
    }
}

