/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.entities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.annotation.Tag;
import nostr.event.BaseTag;
import nostr.event.entities.NIP42Content;
import nostr.event.tag.AddressTag;
import nostr.event.tag.GeohashTag;
import nostr.event.tag.HashtagTag;
import nostr.event.tag.IdentifierTag;
import nostr.event.tag.LabelNamespaceTag;
import nostr.event.tag.LabelTag;
import nostr.event.tag.PubKeyTag;
import nostr.event.tag.ReferenceTag;

public class CalendarContent<T extends BaseTag>
extends NIP42Content {
    private final IdentifierTag identifierTag;
    private final String title;
    private final Long start;
    private Long end;
    private String startTzid;
    private String endTzid;
    private String summary;
    private String image;
    private String location;
    private final Map<String, List<T>> classTypeTagsMap = new HashMap<String, List<T>>();

    public CalendarContent(@NonNull IdentifierTag identifierTag, @NonNull String title, @NonNull Long start) {
        if (identifierTag == null) {
            throw new NullPointerException("identifierTag is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        this.identifierTag = identifierTag;
        this.title = title;
        this.start = start;
    }

    public void setEnd(@NonNull Long end) {
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        this.end = end;
    }

    public Optional<Long> getEnd() {
        return Optional.ofNullable(this.end);
    }

    public void setStartTzid(@NonNull String startTzid) {
        if (startTzid == null) {
            throw new NullPointerException("startTzid is marked non-null but is null");
        }
        this.startTzid = startTzid;
    }

    public Optional<String> getStartTzid() {
        return Optional.ofNullable(this.startTzid);
    }

    public void setEndTzid(@NonNull String endTzid) {
        if (endTzid == null) {
            throw new NullPointerException("endTzid is marked non-null but is null");
        }
        this.endTzid = endTzid;
    }

    public Optional<String> getEndTzid() {
        return Optional.ofNullable(this.endTzid);
    }

    public void setSummary(@NonNull String summary) {
        if (summary == null) {
            throw new NullPointerException("summary is marked non-null but is null");
        }
        this.summary = summary;
    }

    public Optional<String> getSummary() {
        return Optional.ofNullable(this.summary);
    }

    public void setImage(@NonNull String image) {
        if (image == null) {
            throw new NullPointerException("image is marked non-null but is null");
        }
        this.image = image;
    }

    public Optional<String> getImage() {
        return Optional.ofNullable(this.image);
    }

    public void setLocation(@NonNull String location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        this.location = location;
    }

    public Optional<String> getLocation() {
        return Optional.ofNullable(this.location);
    }

    public void addParticipantPubKeyTag(@NonNull PubKeyTag pubKeyTag) {
        if (pubKeyTag == null) {
            throw new NullPointerException("pubKeyTag is marked non-null but is null");
        }
        this.addTag(pubKeyTag);
    }

    public void addParticipantPubKeyTags(@NonNull List<PubKeyTag> pubKeyTags) {
        if (pubKeyTags == null) {
            throw new NullPointerException("pubKeyTags is marked non-null but is null");
        }
        pubKeyTags.forEach(this::addParticipantPubKeyTag);
    }

    public List<PubKeyTag> getParticipantPubKeyTags() {
        return this.getTagsByType(PubKeyTag.class).stream().toList();
    }

    public void addHashtagTag(@NonNull HashtagTag hashtagTag) {
        if (hashtagTag == null) {
            throw new NullPointerException("hashtagTag is marked non-null but is null");
        }
        this.addTag(hashtagTag);
    }

    public void addHashtagTags(@NonNull List<HashtagTag> hashtagTags) {
        if (hashtagTags == null) {
            throw new NullPointerException("hashtagTags is marked non-null but is null");
        }
        hashtagTags.forEach(this::addHashtagTag);
    }

    public List<HashtagTag> getHashtagTags() {
        return this.getTagsByType(HashtagTag.class);
    }

    public void addReferenceTag(@NonNull ReferenceTag referenceTag) {
        if (referenceTag == null) {
            throw new NullPointerException("referenceTag is marked non-null but is null");
        }
        this.addTag(referenceTag);
    }

    public List<ReferenceTag> getReferenceTags() {
        return this.getTagsByType(ReferenceTag.class);
    }

    public void addLabelTag(@NonNull LabelTag labelTag) {
        if (labelTag == null) {
            throw new NullPointerException("labelTag is marked non-null but is null");
        }
        this.addTag(labelTag);
    }

    public void addLabelTags(@NonNull List<LabelTag> labelTags) {
        if (labelTags == null) {
            throw new NullPointerException("labelTags is marked non-null but is null");
        }
        labelTags.forEach(this::addLabelTag);
    }

    public List<LabelTag> getLabelTags() {
        return this.getTagsByType(LabelTag.class);
    }

    public void addLabelNamespaceTag(@NonNull LabelNamespaceTag labelNamespaceTag) {
        if (labelNamespaceTag == null) {
            throw new NullPointerException("labelNamespaceTag is marked non-null but is null");
        }
        this.addTag(labelNamespaceTag);
    }

    public void addLabelNamespaceTags(@NonNull List<LabelNamespaceTag> labelNamespaceTags) {
        if (labelNamespaceTags == null) {
            throw new NullPointerException("labelNamespaceTags is marked non-null but is null");
        }
        labelNamespaceTags.forEach(this::addLabelNamespaceTag);
    }

    public List<LabelNamespaceTag> getLabelNamespaceTags() {
        return this.getTagsByType(LabelNamespaceTag.class);
    }

    public void addAddressTag(@NonNull AddressTag addressTag) {
        if (addressTag == null) {
            throw new NullPointerException("addressTag is marked non-null but is null");
        }
        this.addTag(addressTag);
    }

    public List<AddressTag> getAddressTags() {
        return this.getTagsByType(AddressTag.class);
    }

    public void setGeohashTag(@NonNull GeohashTag geohashTag) {
        if (geohashTag == null) {
            throw new NullPointerException("geohashTag is marked non-null but is null");
        }
        this.addTag(geohashTag);
    }

    public Optional<GeohashTag> getGeohashTag() {
        return this.getTagsByType(GeohashTag.class).stream().findFirst();
    }

    private <E extends BaseTag> List<E> getTagsByType(Class<E> clazz) {
        Tag annotation = clazz.getAnnotation(Tag.class);
        List<BaseTag> list = this.getBaseTags(annotation).stream().map(clazz::cast).toList();
        return list;
    }

    private List<T> getBaseTags(@NonNull Tag type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        String code = type.code();
        List<T> value = this.classTypeTagsMap.get(code);
        Optional value1 = Optional.ofNullable(value);
        List baseTags = value1.orElse(Collections.emptyList());
        return baseTags;
    }

    private void addTag(@NonNull T baseTag) {
        if (baseTag == null) {
            throw new NullPointerException("baseTag is marked non-null but is null");
        }
        String code = ((BaseTag)baseTag).getCode();
        List list = this.classTypeTagsMap.computeIfAbsent(code, k -> new ArrayList());
        list.add(baseTag);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalendarContent)) {
            return false;
        }
        CalendarContent other = (CalendarContent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$start = this.getStart();
        Long other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        Optional<Long> this$end = this.getEnd();
        Optional<Long> other$end = other.getEnd();
        if (this$end == null ? other$end != null : !((Object)this$end).equals(other$end)) {
            return false;
        }
        IdentifierTag this$identifierTag = this.getIdentifierTag();
        IdentifierTag other$identifierTag = other.getIdentifierTag();
        if (this$identifierTag == null ? other$identifierTag != null : !((Object)this$identifierTag).equals(other$identifierTag)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        Optional<String> this$startTzid = this.getStartTzid();
        Optional<String> other$startTzid = other.getStartTzid();
        if (this$startTzid == null ? other$startTzid != null : !((Object)this$startTzid).equals(other$startTzid)) {
            return false;
        }
        Optional<String> this$endTzid = this.getEndTzid();
        Optional<String> other$endTzid = other.getEndTzid();
        if (this$endTzid == null ? other$endTzid != null : !((Object)this$endTzid).equals(other$endTzid)) {
            return false;
        }
        Optional<String> this$summary = this.getSummary();
        Optional<String> other$summary = other.getSummary();
        if (this$summary == null ? other$summary != null : !((Object)this$summary).equals(other$summary)) {
            return false;
        }
        Optional<String> this$image = this.getImage();
        Optional<String> other$image = other.getImage();
        if (this$image == null ? other$image != null : !((Object)this$image).equals(other$image)) {
            return false;
        }
        Optional<String> this$location = this.getLocation();
        Optional<String> other$location = other.getLocation();
        if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
            return false;
        }
        Map<String, List<T>> this$classTypeTagsMap = this.classTypeTagsMap;
        Map<String, List<T>> other$classTypeTagsMap = other.classTypeTagsMap;
        return !(this$classTypeTagsMap == null ? other$classTypeTagsMap != null : !((Object)this$classTypeTagsMap).equals(other$classTypeTagsMap));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalendarContent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        Optional<Long> $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        IdentifierTag $identifierTag = this.getIdentifierTag();
        result = result * 59 + ($identifierTag == null ? 43 : ((Object)$identifierTag).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        Optional<String> $startTzid = this.getStartTzid();
        result = result * 59 + ($startTzid == null ? 43 : ((Object)$startTzid).hashCode());
        Optional<String> $endTzid = this.getEndTzid();
        result = result * 59 + ($endTzid == null ? 43 : ((Object)$endTzid).hashCode());
        Optional<String> $summary = this.getSummary();
        result = result * 59 + ($summary == null ? 43 : ((Object)$summary).hashCode());
        Optional<String> $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : ((Object)$image).hashCode());
        Optional<String> $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        Map<String, List<T>> $classTypeTagsMap = this.classTypeTagsMap;
        result = result * 59 + ($classTypeTagsMap == null ? 43 : ((Object)$classTypeTagsMap).hashCode());
        return result;
    }

    @Generated
    public IdentifierTag getIdentifierTag() {
        return this.identifierTag;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public Long getStart() {
        return this.start;
    }
}

