/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.filter;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Predicate;
import lombok.NonNull;
import nostr.base.json.EventJsonMapper;
import nostr.event.BaseTag;
import nostr.event.impl.GenericEvent;

public interface Filterable {
    public Predicate<GenericEvent> getPredicate();

    public <T> T getFilterable();

    public Object getFilterableValue();

    public String getFilterKey();

    public static <T extends BaseTag> List<T> getTypeSpecificTags(@NonNull Class<T> tagClass, @NonNull GenericEvent event) {
        if (tagClass == null) {
            throw new NullPointerException("tagClass is marked non-null but is null");
        }
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        return event.getTags().stream().filter(tagClass::isInstance).map(tagClass::cast).toList();
    }

    public static <T extends BaseTag> Optional<T> firstTagOfType(@NonNull Class<T> tagClass, @NonNull GenericEvent event) {
        if (tagClass == null) {
            throw new NullPointerException("tagClass is marked non-null but is null");
        }
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        return Filterable.getTypeSpecificTags(tagClass, event).stream().findFirst();
    }

    public static <T extends BaseTag> Optional<T> firstTagOfTypeWithCode(@NonNull Class<T> tagClass, @NonNull String code, @NonNull GenericEvent event) {
        if (tagClass == null) {
            throw new NullPointerException("tagClass is marked non-null but is null");
        }
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        return Filterable.getTypeSpecificTags(tagClass, event).stream().filter(t -> code.equals(t.getCode())).findFirst();
    }

    public static <T extends BaseTag> T requireTagOfType(@NonNull Class<T> tagClass, @NonNull GenericEvent event, @NonNull String errorMessage) {
        if (tagClass == null) {
            throw new NullPointerException("tagClass is marked non-null but is null");
        }
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (errorMessage == null) {
            throw new NullPointerException("errorMessage is marked non-null but is null");
        }
        return (T)((BaseTag)Filterable.firstTagOfType(tagClass, event).orElseThrow(() -> new NoSuchElementException(errorMessage)));
    }

    public static <T extends BaseTag> T requireTagOfTypeWithCode(@NonNull Class<T> tagClass, @NonNull String code, @NonNull GenericEvent event, @NonNull String errorMessage) {
        if (tagClass == null) {
            throw new NullPointerException("tagClass is marked non-null but is null");
        }
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (errorMessage == null) {
            throw new NullPointerException("errorMessage is marked non-null but is null");
        }
        return (T)((BaseTag)Filterable.firstTagOfTypeWithCode(tagClass, code, event).orElseThrow(() -> new NoSuchElementException(errorMessage)));
    }

    public static <T extends BaseTag> T requireTagOfTypeWithCode(@NonNull Class<T> tagClass, @NonNull String code, @NonNull GenericEvent event) {
        if (tagClass == null) {
            throw new NullPointerException("tagClass is marked non-null but is null");
        }
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        return Filterable.requireTagOfTypeWithCode(tagClass, code, event, "Missing required tag of type %s with code '%s'".formatted(tagClass.getSimpleName(), code));
    }

    default public ObjectNode toObjectNode(ObjectNode objectNode) {
        ArrayNode arrayNode = EventJsonMapper.mapper().createArrayNode();
        Optional.ofNullable(objectNode.get(this.getFilterKey())).ifPresent(jsonNode -> jsonNode.elements().forEachRemaining(arrayNode::add));
        this.addToArrayNode(arrayNode);
        return (ObjectNode)objectNode.set(this.getFilterKey(), arrayNode);
    }

    default public void addToArrayNode(ArrayNode arrayNode) {
        arrayNode.addAll(EventJsonMapper.mapper().createArrayNode().add(this.getFilterableValue().toString()));
    }
}

