/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.filter;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;
import nostr.base.ElementAttribute;
import nostr.base.GenericTagQuery;
import nostr.event.filter.AbstractFilterable;
import nostr.event.filter.Filterable;
import nostr.event.impl.GenericEvent;
import nostr.event.tag.GenericTag;

public class GenericTagQueryFilter<T extends GenericTagQuery>
extends AbstractFilterable<T> {
    public static final String HASH_PREFIX = "#";

    public GenericTagQueryFilter(T genericTagQuery) {
        super(genericTagQuery, ((GenericTagQuery)genericTagQuery).tagName());
    }

    @Override
    public Predicate<GenericEvent> getPredicate() {
        return genericEvent -> Filterable.getTypeSpecificTags(GenericTag.class, genericEvent).stream().filter(genericTag -> genericTag.getCode().equals(this.stripLeadingHashTag())).anyMatch(genericTag -> genericTag.getAttributes().stream().map(ElementAttribute::value).toList().contains(this.getFilterableValue()));
    }

    @Override
    public String getFilterKey() {
        return ((GenericTagQuery)this.getGenericTagQuery()).tagName();
    }

    @Override
    public String getFilterableValue() {
        return ((GenericTagQuery)this.getGenericTagQuery()).value();
    }

    private T getGenericTagQuery() {
        return (T)((GenericTagQuery)super.getFilterable());
    }

    private String stripLeadingHashTag() {
        return this.getFilterKey().startsWith(HASH_PREFIX) ? this.getFilterKey().substring(1) : this.getFilterKey();
    }

    public static Function<JsonNode, Filterable> fxn(String type) {
        return node -> new GenericTagQueryFilter<GenericTagQuery>(new GenericTagQuery(type, node.asText()));
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenericTagQueryFilter)) {
            return false;
        }
        GenericTagQueryFilter other = (GenericTagQueryFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GenericTagQueryFilter;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

