/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.filter;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;
import nostr.event.filter.AbstractFilterable;
import nostr.event.filter.Filterable;
import nostr.event.impl.GenericEvent;
import nostr.event.tag.HashtagTag;

public class HashtagTagFilter<T extends HashtagTag>
extends AbstractFilterable<T> {
    public static final String FILTER_KEY = "#t";
    public static Function<JsonNode, Filterable> fxn = node -> new HashtagTagFilter<HashtagTag>(new HashtagTag(node.asText()));

    public HashtagTagFilter(T hashtagTag) {
        super(hashtagTag, FILTER_KEY);
    }

    @Override
    public Predicate<GenericEvent> getPredicate() {
        return genericEvent -> Filterable.getTypeSpecificTags(HashtagTag.class, genericEvent).stream().anyMatch(hashtagTag -> hashtagTag.getHashTag().equals(this.getFilterableValue()));
    }

    @Override
    public String getFilterableValue() {
        return ((HashtagTag)this.getHashtagTag()).getHashTag();
    }

    private T getHashtagTag() {
        return (T)((HashtagTag)super.getFilterable());
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HashtagTagFilter)) {
            return false;
        }
        HashtagTagFilter other = (HashtagTagFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HashtagTagFilter;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

