/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.filter;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;
import nostr.event.filter.AbstractFilterable;
import nostr.event.filter.Filterable;
import nostr.event.impl.GenericEvent;
import nostr.event.tag.VoteTag;

public class VoteTagFilter<T extends VoteTag>
extends AbstractFilterable<T> {
    public static final String FILTER_KEY = "#v";
    public static Function<JsonNode, Filterable> fxn = node -> new VoteTagFilter<VoteTag>(new VoteTag(node.asInt()));

    public VoteTagFilter(T voteTag) {
        super(voteTag, FILTER_KEY);
    }

    @Override
    public Predicate<GenericEvent> getPredicate() {
        return genericEvent -> Filterable.getTypeSpecificTags(VoteTag.class, genericEvent).stream().anyMatch(voteTag -> voteTag.getVote().equals(this.getFilterableValue()));
    }

    @Override
    public Integer getFilterableValue() {
        return ((VoteTag)this.getVoteTag()).getVote();
    }

    private T getVoteTag() {
        return (T)((VoteTag)super.getFilterable());
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VoteTagFilter)) {
            return false;
        }
        VoteTagFilter other = (VoteTagFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof VoteTagFilter;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

