/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.impl;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.Kind;
import nostr.base.PublicKey;
import nostr.base.annotation.Event;
import nostr.event.BaseTag;
import nostr.event.JsonContent;
import nostr.event.entities.CalendarContent;
import nostr.event.filter.Filterable;
import nostr.event.impl.CalendarDateBasedEvent;
import nostr.event.json.deserializer.CalendarTimeBasedEventDeserializer;
import nostr.event.tag.GenericTag;
import nostr.event.tag.LabelTag;

@Event(name="Time-Based Calendar Event", nip=52)
@JsonDeserialize(using=CalendarTimeBasedEventDeserializer.class)
public class CalendarTimeBasedEvent<T extends BaseTag>
extends CalendarDateBasedEvent<T> {
    public CalendarTimeBasedEvent(@NonNull PublicKey sender, @NonNull List<BaseTag> baseTags, @NonNull String content) {
        super(sender, baseTags, content);
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (baseTags == null) {
            throw new NullPointerException("baseTags is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        this.setKind(Kind.CALENDAR_TIME_BASED_EVENT.getValue());
    }

    public Optional<String> getStartTzid() {
        return ((CalendarContent)this.getCalendarContent()).getStartTzid();
    }

    public Optional<String> getEndTzid() {
        return ((CalendarContent)this.getCalendarContent()).getEndTzid();
    }

    public Optional<String> getSummary() {
        return ((CalendarContent)this.getCalendarContent()).getSummary();
    }

    @Override
    public Optional<String> getLocation() {
        return super.getLocation();
    }

    public List<String> getLabels() {
        List<LabelTag> labelTags = ((CalendarContent)this.getCalendarContent()).getLabelTags();
        return labelTags.stream().map(l -> "#" + l.getNameSpace() + "." + l.getLabel()).toList();
    }

    @Override
    protected CalendarContent<T> getCalendarContent() {
        JsonContent calendarContent = super.getCalendarContent();
        ((CalendarContent)calendarContent).setStartTzid(Filterable.requireTagOfTypeWithCode(GenericTag.class, "start_tzid", this).getAttributes().get(0).value().toString());
        ((CalendarContent)calendarContent).setEndTzid(Filterable.requireTagOfTypeWithCode(GenericTag.class, "end_tzid", this).getAttributes().get(0).value().toString());
        ((CalendarContent)calendarContent).setSummary(Filterable.requireTagOfTypeWithCode(GenericTag.class, "summary", this).getAttributes().get(0).value().toString());
        ((CalendarContent)calendarContent).setLocation(Filterable.requireTagOfTypeWithCode(GenericTag.class, "location", this).getAttributes().get(0).value().toString());
        Filterable.getTypeSpecificTags(LabelTag.class, this).forEach(((CalendarContent)calendarContent)::addLabelTag);
        return calendarContent;
    }

    @Override
    public void validateKind() {
        if (this.getKind().intValue() != Kind.CALENDAR_TIME_BASED_EVENT.getValue()) {
            throw new AssertionError((Object)("Invalid kind value. Expected " + Kind.CALENDAR_TIME_BASED_EVENT.getValue()));
        }
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalendarTimeBasedEvent)) {
            return false;
        }
        CalendarTimeBasedEvent other = (CalendarTimeBasedEvent)o;
        return other.canEqual(this);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalendarTimeBasedEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public CalendarTimeBasedEvent() {
    }
}

