/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import lombok.Generated;
import nostr.base.Kind;
import nostr.base.PublicKey;
import nostr.base.annotation.Event;
import nostr.base.json.EventJsonMapper;
import nostr.event.NIP05Event;
import nostr.event.entities.UserProfile;
import nostr.event.json.codec.EventEncodingException;

@Event(name="Internet Identifier Metadata Event", nip=5)
public final class InternetIdentifierMetadataEvent
extends NIP05Event {
    private static final String NAME_PATTERN = "\\w[\\w\\-]+\\w";

    public InternetIdentifierMetadataEvent(PublicKey pubKey, String content) {
        super(pubKey, Kind.SET_METADATA);
        this.setContent(content);
    }

    public UserProfile getProfile() {
        String content = this.getContent();
        try {
            return EventJsonMapper.mapper().readValue(content, UserProfile.class);
        }
        catch (JsonProcessingException ex) {
            throw new EventEncodingException("Failed to parse user profile content", ex);
        }
    }

    @Override
    protected void validateContent() {
        super.validateContent();
        UserProfile profile2 = this.getProfile();
        if (profile2.getNip05() == null || profile2.getNip05().isEmpty()) {
            throw new AssertionError((Object)"Invalid `content`: `nip05` field must not be null or empty.");
        }
        boolean valid = true;
        String[] strNameArr = profile2.getNip05().split("@");
        if (strNameArr.length == 2) {
            String localPart = strNameArr[0];
            valid = localPart.matches(NAME_PATTERN);
        }
        if (!valid) {
            throw new AssertionError("Invalid profile name: " + String.valueOf(profile2), null);
        }
    }

    @Override
    protected void validateKind() {
        if (this.getKind().intValue() != Kind.SET_METADATA.getValue()) {
            throw new AssertionError((Object)("Invalid kind value. Expected " + Kind.SET_METADATA.getValue()));
        }
    }

    @Override
    @Generated
    public String toString() {
        return "InternetIdentifierMetadataEvent()";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InternetIdentifierMetadataEvent)) {
            return false;
        }
        InternetIdentifierMetadataEvent other = (InternetIdentifierMetadataEvent)o;
        return other.canEqual(this);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InternetIdentifierMetadataEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public InternetIdentifierMetadataEvent() {
    }
}

