/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.json.codec;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.IDecoder;
import nostr.base.json.EventJsonMapper;
import nostr.event.filter.Filterable;
import nostr.event.filter.Filters;
import nostr.event.json.codec.EventEncodingException;
import nostr.event.json.codec.FilterableProvider;

public class FiltersDecoder
implements IDecoder<Filters> {
    @Override
    public Filters decode(@NonNull String jsonFiltersList) throws EventEncodingException {
        if (jsonFiltersList == null) {
            throw new NullPointerException("jsonFiltersList is marked non-null but is null");
        }
        try {
            ArrayList<Filterable> filterables = new ArrayList<Filterable>();
            Map<String, JsonNode> filtersMap = EventJsonMapper.mapper().readValue(jsonFiltersList, new TypeReference<Map<String, JsonNode>>(this){});
            for (Map.Entry<String, JsonNode> entry : filtersMap.entrySet()) {
                filterables.addAll(FilterableProvider.getFilterFunction(entry.getValue(), entry.getKey()));
            }
            return new Filters(filterables);
        }
        catch (JsonProcessingException e) {
            throw new EventEncodingException("Failed to decode filters", e);
        }
    }

    @Generated
    public FiltersDecoder() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FiltersDecoder)) {
            return false;
        }
        FiltersDecoder other = (FiltersDecoder)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FiltersDecoder;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "FiltersDecoder()";
    }
}

