/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.json.codec;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.ElementAttribute;
import nostr.base.IDecoder;
import nostr.event.json.codec.EventEncodingException;
import nostr.event.tag.GenericTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericTagDecoder<T extends GenericTag>
implements IDecoder<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenericTagDecoder.class);
    private final Class<T> clazz;

    public GenericTagDecoder() {
        this(GenericTag.class);
    }

    public GenericTagDecoder(@NonNull Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        this.clazz = clazz;
    }

    @Override
    public T decode(@NonNull String json) throws EventEncodingException {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        try {
            String[] jsonElements = I_DECODER_MAPPER_BLACKBIRD.readValue(json, String[].class);
            ArrayList<ElementAttribute> attributes = new ArrayList<ElementAttribute>(Math.max(0, jsonElements.length - 1));
            for (int i2 = 1; i2 < jsonElements.length; ++i2) {
                ElementAttribute attribute = new ElementAttribute("param" + (i2 - 1), jsonElements[i2]);
                if (attributes.contains(attribute)) continue;
                attributes.add(attribute);
            }
            GenericTag genericTag = new GenericTag(jsonElements[0], attributes);
            log.debug("Decoded GenericTag: {}", (Object)genericTag);
            return (T)genericTag;
        }
        catch (JsonProcessingException ex) {
            throw new EventEncodingException("Failed to decode generic tag", ex);
        }
    }

    @Generated
    public Class<T> getClazz() {
        return this.clazz;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenericTagDecoder)) {
            return false;
        }
        GenericTagDecoder other = (GenericTagDecoder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Class<T> this$clazz = this.getClazz();
        Class<T> other$clazz = other.getClazz();
        return !(this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GenericTagDecoder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<T> $clazz = this.getClazz();
        result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GenericTagDecoder(clazz=" + String.valueOf(this.getClazz()) + ")";
    }
}

