/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.message;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.Command;
import nostr.base.IDecoder;
import nostr.base.IEvent;
import nostr.event.BaseEvent;
import nostr.event.BaseMessage;
import nostr.event.impl.GenericEvent;
import nostr.event.json.EventJsonMapper;
import nostr.event.json.codec.BaseEventEncoder;
import nostr.event.json.codec.EventEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMessage
extends BaseMessage {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventMessage.class);
    private static final int SIZE_JSON_EVENT_wo_SIG_ID = 2;
    private static final Function<Object[], Boolean> isEventWoSig = objArr -> Objects.equals(2, ((Object[])objArr).length);
    @JsonProperty
    private final IEvent event;
    @JsonProperty
    private String subscriptionId;

    public EventMessage(@NonNull IEvent event) {
        super(Command.EVENT.name());
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.event = event;
    }

    public EventMessage(@NonNull IEvent event, @NonNull String subscriptionId) {
        this(event);
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId is marked non-null but is null");
        }
        this.subscriptionId = subscriptionId;
    }

    @Override
    public String encode() throws EventEncodingException {
        ArrayNode arrayNode = JsonNodeFactory.instance.arrayNode().add(this.getCommand());
        Optional.ofNullable(this.getSubscriptionId()).ifPresent(arrayNode::add);
        try {
            arrayNode.add(EventJsonMapper.getMapper().readTree(new BaseEventEncoder<BaseEvent>((BaseEvent)this.getEvent()).encode()));
            return EventJsonMapper.getMapper().writeValueAsString(arrayNode);
        }
        catch (JsonProcessingException e) {
            throw new EventEncodingException("Failed to encode event message", e);
        }
    }

    public static <T extends BaseMessage> T decode(@NonNull String jsonString) throws EventEncodingException {
        if (jsonString == null) {
            throw new NullPointerException("jsonString is marked non-null but is null");
        }
        try {
            Object[] msgArr = IDecoder.I_DECODER_MAPPER_BLACKBIRD.readValue(jsonString, Object[].class);
            return isEventWoSig.apply(msgArr) != false ? EventMessage.processEvent(msgArr[1]) : EventMessage.processEvent(msgArr);
        }
        catch (JsonProcessingException e) {
            throw new EventEncodingException("Invalid argument: " + jsonString, e);
        }
    }

    private static <T extends BaseMessage> T processEvent(Object o) {
        EventMessage result = new EventMessage(EventMessage.convertValue((Map)o));
        return (T)result;
    }

    private static <T extends BaseMessage> T processEvent(Object[] msgArr) {
        EventMessage result = new EventMessage(EventMessage.convertValue((Map)msgArr[2]), msgArr[1].toString());
        return (T)result;
    }

    private static GenericEvent convertValue(Map<?, ?> map) {
        log.info("Converting map to GenericEvent: {}", (Object)map);
        return IDecoder.I_DECODER_MAPPER_BLACKBIRD.convertValue(map, new TypeReference<GenericEvent>(){});
    }

    @JsonProperty
    @Generated
    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    @Generated
    public IEvent getEvent() {
        return this.event;
    }

    @Generated
    public String getSubscriptionId() {
        return this.subscriptionId;
    }
}

