/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.message;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.ElementAttribute;
import nostr.base.IElement;
import nostr.base.IGenericElement;
import nostr.event.BaseMessage;
import nostr.event.json.EventJsonMapper;
import nostr.event.json.codec.EventEncodingException;

public class GenericMessage
extends BaseMessage
implements IGenericElement,
IElement {
    @JsonIgnore
    private final List<ElementAttribute> attributes;

    public GenericMessage(String command) {
        this(command, new ArrayList<ElementAttribute>());
    }

    public GenericMessage(String command, List<ElementAttribute> attributes) {
        super(command);
        this.attributes = attributes;
    }

    @Override
    public void addAttribute(ElementAttribute ... attribute) {
        this.addAttributes(List.of(attribute));
    }

    @Override
    public void addAttributes(List<ElementAttribute> attributes) {
        this.attributes.addAll(attributes);
    }

    @Override
    public String encode() throws EventEncodingException {
        ArrayNode encoderArrayNode = JsonNodeFactory.instance.arrayNode();
        encoderArrayNode.add(this.getCommand());
        this.getAttributes().stream().map(ElementAttribute::value).forEach(v -> encoderArrayNode.add(v.toString()));
        try {
            return EventJsonMapper.getMapper().writeValueAsString(encoderArrayNode);
        }
        catch (JsonProcessingException e) {
            throw new EventEncodingException("Failed to encode generic message", e);
        }
    }

    public static <T extends BaseMessage> T decode(@NonNull Object[] msgArr) {
        if (msgArr == null) {
            throw new NullPointerException("msgArr is marked non-null but is null");
        }
        GenericMessage gm = new GenericMessage(msgArr[0].toString());
        for (int i2 = 1; i2 < msgArr.length; ++i2) {
            if (!(msgArr[i2] instanceof String)) continue;
            gm.addAttribute(new ElementAttribute(null, msgArr[i2]));
        }
        GenericMessage result = gm;
        return (T)result;
    }

    @Override
    @Generated
    public List<ElementAttribute> getAttributes() {
        return this.attributes;
    }
}

