/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.support;

import java.lang.reflect.InvocationTargetException;
import lombok.NonNull;
import nostr.event.impl.GenericEvent;
import nostr.util.NostrException;

public final class GenericEventConverter {
    private GenericEventConverter() {
    }

    public static <T extends GenericEvent> T convert(@NonNull GenericEvent source2, @NonNull Class<T> target) throws NostrException {
        if (source2 == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        try {
            GenericEvent event = (GenericEvent)target.getConstructor(new Class[0]).newInstance(new Object[0]);
            event.setContent(source2.getContent());
            event.setTags(source2.getTags());
            event.setPubKey(source2.getPubKey());
            event.setId(source2.getId());
            event.setSerializedEventCache(source2.getSerializedEventCache());
            event.setNip(source2.getNip());
            event.setKind(source2.getKind());
            event.setSignature(source2.getSignature());
            event.setCreatedAt(source2.getCreatedAt());
            return (T)event;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new NostrException("Failed to convert GenericEvent", e);
        }
    }
}

