/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.tag;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonNode;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.annotation.Key;
import nostr.base.annotation.Tag;
import nostr.event.BaseTag;
import nostr.event.tag.GenericTag;

@Tag(code="nonce", nip=13)
@JsonPropertyOrder(value={"nonce", "difficulty"})
public class NonceTag
extends BaseTag {
    @Key
    @JsonProperty(value="nonce")
    private Integer nonce;
    @Key
    @JsonProperty(value="difficulty")
    private Integer difficulty;

    public NonceTag(@NonNull Integer nonce, @NonNull Integer difficulty) {
        if (nonce == null) {
            throw new NullPointerException("nonce is marked non-null but is null");
        }
        if (difficulty == null) {
            throw new NullPointerException("difficulty is marked non-null but is null");
        }
        this.nonce = nonce;
        this.difficulty = difficulty;
    }

    public static NonceTag deserialize(@NonNull JsonNode node) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        NonceTag tag = new NonceTag();
        NonceTag.setRequiredField(node.get(1), (n, t) -> tag.setNonce(n.asInt()), tag);
        NonceTag.setRequiredField(node.get(2), (n, t) -> tag.setDifficulty(n.asInt()), tag);
        return tag;
    }

    public static NonceTag updateFields(@NonNull GenericTag genericTag) {
        if (genericTag == null) {
            throw new NullPointerException("genericTag is marked non-null but is null");
        }
        if (!"nonce".equals(genericTag.getCode())) {
            throw new IllegalArgumentException("Invalid tag code for NonceTag");
        }
        if (genericTag.getAttributes().size() != 2) {
            throw new IllegalArgumentException("Invalid number of attributes for NonceTag");
        }
        return new NonceTag(Integer.valueOf(genericTag.getAttributes().get(0).value().toString()), Integer.valueOf(genericTag.getAttributes().get(1).value().toString()));
    }

    @Generated
    public static NonceTagBuilder builder() {
        return new NonceTagBuilder();
    }

    @Generated
    public Integer getNonce() {
        return this.nonce;
    }

    @Generated
    public Integer getDifficulty() {
        return this.difficulty;
    }

    @JsonProperty(value="nonce")
    @Generated
    public void setNonce(Integer nonce) {
        this.nonce = nonce;
    }

    @JsonProperty(value="difficulty")
    @Generated
    public void setDifficulty(Integer difficulty) {
        this.difficulty = difficulty;
    }

    @Override
    @Generated
    public String toString() {
        return "NonceTag(nonce=" + this.getNonce() + ", difficulty=" + this.getDifficulty() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NonceTag)) {
            return false;
        }
        NonceTag other = (NonceTag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$nonce = this.getNonce();
        Integer other$nonce = other.getNonce();
        if (this$nonce == null ? other$nonce != null : !((Object)this$nonce).equals(other$nonce)) {
            return false;
        }
        Integer this$difficulty = this.getDifficulty();
        Integer other$difficulty = other.getDifficulty();
        return !(this$difficulty == null ? other$difficulty != null : !((Object)this$difficulty).equals(other$difficulty));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NonceTag;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $nonce = this.getNonce();
        result = result * 59 + ($nonce == null ? 43 : ((Object)$nonce).hashCode());
        Integer $difficulty = this.getDifficulty();
        result = result * 59 + ($difficulty == null ? 43 : ((Object)$difficulty).hashCode());
        return result;
    }

    @Generated
    public NonceTag() {
    }

    @Generated
    public static class NonceTagBuilder {
        @Generated
        private Integer nonce;
        @Generated
        private Integer difficulty;

        @Generated
        NonceTagBuilder() {
        }

        @JsonProperty(value="nonce")
        @Generated
        public NonceTagBuilder nonce(Integer nonce) {
            this.nonce = nonce;
            return this;
        }

        @JsonProperty(value="difficulty")
        @Generated
        public NonceTagBuilder difficulty(Integer difficulty) {
            this.difficulty = difficulty;
            return this;
        }

        @Generated
        public NonceTag build() {
            return new NonceTag(this.nonce, this.difficulty);
        }

        @Generated
        public String toString() {
            return "NonceTag.NonceTagBuilder(nonce=" + this.nonce + ", difficulty=" + this.difficulty + ")";
        }
    }
}

