/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.tag;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.net.URI;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.Marker;
import nostr.base.annotation.Key;
import nostr.base.annotation.Tag;
import nostr.event.BaseTag;
import nostr.event.json.serializer.ReferenceTagSerializer;
import nostr.event.tag.GenericTag;

@Tag(code="r", nip=12)
@JsonSerialize(using=ReferenceTagSerializer.class)
public class ReferenceTag
extends BaseTag {
    @Key
    @JsonProperty(value="uri")
    private URI uri;
    @Key
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Marker marker;

    public ReferenceTag(@NonNull URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        this.uri = uri;
    }

    public Optional<URI> getUrl() {
        return Optional.ofNullable(this.uri);
    }

    public Optional<Marker> getMarkerOptional() {
        return Optional.ofNullable(this.marker);
    }

    public static ReferenceTag deserialize(@NonNull JsonNode node) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        ReferenceTag tag = new ReferenceTag();
        ReferenceTag.setRequiredField(node.get(1), (n, t) -> tag.setUri(URI.create(n.asText())), tag);
        ReferenceTag.setOptionalField(node.get(2), (n, t) -> tag.setMarker(Marker.valueOf(n.asText().toUpperCase())), tag);
        return tag;
    }

    public static ReferenceTag updateFields(@NonNull GenericTag genericTag) {
        if (genericTag == null) {
            throw new NullPointerException("genericTag is marked non-null but is null");
        }
        if (!"r".equals(genericTag.getCode())) {
            throw new IllegalArgumentException("Invalid tag code for ReferenceTag");
        }
        if (genericTag.getAttributes().size() < 1 || genericTag.getAttributes().size() > 2) {
            throw new IllegalArgumentException("Invalid number of attributes for ReferenceTag");
        }
        return new ReferenceTag(URI.create(genericTag.getAttributes().get(0).value().toString()), genericTag.getAttributes().size() == 2 ? Marker.valueOf(genericTag.getAttributes().get(1).value().toString().toUpperCase()) : null);
    }

    @Generated
    public static ReferenceTagBuilder builder() {
        return new ReferenceTagBuilder();
    }

    @Generated
    public URI getUri() {
        return this.uri;
    }

    @Generated
    public Marker getMarker() {
        return this.marker;
    }

    @JsonProperty(value="uri")
    @Generated
    public void setUri(URI uri) {
        this.uri = uri;
    }

    @Generated
    public void setMarker(Marker marker) {
        this.marker = marker;
    }

    @Override
    @Generated
    public String toString() {
        return "ReferenceTag(uri=" + String.valueOf(this.getUri()) + ", marker=" + String.valueOf((Object)this.getMarker()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReferenceTag)) {
            return false;
        }
        ReferenceTag other = (ReferenceTag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        URI this$uri = this.getUri();
        URI other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !((Object)this$uri).equals(other$uri)) {
            return false;
        }
        Marker this$marker = this.getMarker();
        Marker other$marker = other.getMarker();
        return !(this$marker == null ? other$marker != null : !((Object)((Object)this$marker)).equals((Object)other$marker));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReferenceTag;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        URI $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : ((Object)$uri).hashCode());
        Marker $marker = this.getMarker();
        result = result * 59 + ($marker == null ? 43 : ((Object)((Object)$marker)).hashCode());
        return result;
    }

    @Generated
    public ReferenceTag() {
    }

    @Generated
    public ReferenceTag(URI uri, Marker marker) {
        this.uri = uri;
        this.marker = marker;
    }

    @Generated
    public static class ReferenceTagBuilder {
        @Generated
        private URI uri;
        @Generated
        private Marker marker;

        @Generated
        ReferenceTagBuilder() {
        }

        @JsonProperty(value="uri")
        @Generated
        public ReferenceTagBuilder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        @Generated
        public ReferenceTagBuilder marker(Marker marker) {
            this.marker = marker;
            return this;
        }

        @Generated
        public ReferenceTag build() {
            return new ReferenceTag(this.uri, this.marker);
        }

        @Generated
        public String toString() {
            return "ReferenceTag.ReferenceTagBuilder(uri=" + String.valueOf(this.uri) + ", marker=" + String.valueOf((Object)this.marker) + ")";
        }
    }
}

