/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.tag;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import nostr.event.BaseTag;
import nostr.event.tag.AddressTag;
import nostr.event.tag.EmojiTag;
import nostr.event.tag.EventTag;
import nostr.event.tag.ExpirationTag;
import nostr.event.tag.GenericTag;
import nostr.event.tag.GeohashTag;
import nostr.event.tag.HashtagTag;
import nostr.event.tag.IdentifierTag;
import nostr.event.tag.LabelNamespaceTag;
import nostr.event.tag.LabelTag;
import nostr.event.tag.NonceTag;
import nostr.event.tag.PriceTag;
import nostr.event.tag.PubKeyTag;
import nostr.event.tag.ReferenceTag;
import nostr.event.tag.RelaysTag;
import nostr.event.tag.SubjectTag;
import nostr.event.tag.UrlTag;
import nostr.event.tag.VoteTag;

public final class TagRegistry {
    private static final Map<String, Function<GenericTag, ? extends BaseTag>> REGISTRY = new ConcurrentHashMap<String, Function<GenericTag, ? extends BaseTag>>();

    private TagRegistry() {
    }

    public static void register(String code, Function<GenericTag, ? extends BaseTag> factory2) {
        REGISTRY.put(code, factory2);
    }

    public static Function<GenericTag, ? extends BaseTag> get(String code) {
        return REGISTRY.get(code);
    }

    static {
        TagRegistry.register("a", AddressTag::updateFields);
        TagRegistry.register("d", IdentifierTag::updateFields);
        TagRegistry.register("e", EventTag::updateFields);
        TagRegistry.register("g", GeohashTag::updateFields);
        TagRegistry.register("l", LabelTag::updateFields);
        TagRegistry.register("L", LabelNamespaceTag::updateFields);
        TagRegistry.register("p", PubKeyTag::updateFields);
        TagRegistry.register("r", ReferenceTag::updateFields);
        TagRegistry.register("t", HashtagTag::updateFields);
        TagRegistry.register("u", UrlTag::updateFields);
        TagRegistry.register("v", VoteTag::updateFields);
        TagRegistry.register("emoji", EmojiTag::updateFields);
        TagRegistry.register("expiration", ExpirationTag::updateFields);
        TagRegistry.register("nonce", NonceTag::updateFields);
        TagRegistry.register("price", PriceTag::updateFields);
        TagRegistry.register("relays", RelaysTag::updateFields);
        TagRegistry.register("subject", SubjectTag::updateFields);
    }
}

