/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.util;

public final class EventTypeChecker {
    private EventTypeChecker() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static boolean isReplaceable(Integer kind) {
        return kind != null && kind >= 10000 && kind < 20000;
    }

    public static boolean isEphemeral(Integer kind) {
        return kind != null && kind >= 20000 && kind < 30000;
    }

    public static boolean isAddressable(Integer kind) {
        return kind != null && kind >= 30000 && kind < 40000;
    }

    public static boolean isRegular(Integer kind) {
        return kind != null && !EventTypeChecker.isReplaceable(kind) && !EventTypeChecker.isEphemeral(kind) && !EventTypeChecker.isAddressable(kind);
    }

    public static String getTypeName(Integer kind) {
        if (EventTypeChecker.isEphemeral(kind)) {
            return "ephemeral";
        }
        if (EventTypeChecker.isAddressable(kind)) {
            return "addressable";
        }
        if (EventTypeChecker.isReplaceable(kind)) {
            return "replaceable";
        }
        return "regular";
    }
}

