/*
 * Decompiled with CFR 0.152.
 */
package nostr.util.validator;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.module.blackbird.BlackbirdModule;
import java.io.IOException;
import java.net.IDN;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import lombok.Generated;
import nostr.util.NostrException;
import nostr.util.http.DefaultHttpClientProvider;
import nostr.util.http.HttpClientProvider;
import nostr.util.validator.Nip05Content;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Nip05Validator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Nip05Validator.class);
    private final String nip05;
    private final String publicKey;
    @JsonIgnore
    private final Duration connectTimeout;
    @JsonIgnore
    private final Duration requestTimeout;
    @JsonIgnore
    private final HttpClientProvider httpClientProvider;
    private static final Pattern LOCAL_PART_PATTERN = Pattern.compile("^[a-zA-Z0-9-_.]+$");
    private static final Pattern DOMAIN_PATTERN = Pattern.compile("^[A-Za-z0-9.-]+(:\\d{1,5})?$");
    private static final ObjectMapper MAPPER_BLACKBIRD = ((JsonMapper.Builder)JsonMapper.builder().addModule(new BlackbirdModule())).build();

    public void validate() throws NostrException {
        if (this.nip05 == null) {
            return;
        }
        String[] split = this.nip05.trim().split("@");
        if (split.length != 2) {
            throw new NostrException("Invalid nip05 identifier format.");
        }
        String localPart = split[0].trim();
        String domainPart = split[1].trim();
        if (!LOCAL_PART_PATTERN.matcher(localPart).matches()) {
            throw new NostrException("Invalid <local-part> syntax in nip05 attribute.");
        }
        if (!DOMAIN_PATTERN.matcher(domainPart).matches()) {
            throw new NostrException("Invalid domain syntax in nip05 attribute.");
        }
        localPart = localPart.toLowerCase(Locale.ROOT);
        int port = -1;
        String[] hostPort = domainPart.split(":", 2);
        String host = IDN.toASCII(hostPort[0].toLowerCase(Locale.ROOT));
        if (hostPort.length == 2) {
            try {
                port = Integer.parseInt(hostPort[1]);
            }
            catch (NumberFormatException ex) {
                throw new NostrException("Invalid port in domain.");
            }
            if (port < 0 || port > 65535) {
                throw new NostrException("Invalid port in domain.");
            }
        }
        this.validatePublicKey(host, port, localPart);
    }

    private void validatePublicKey(String host, int port, String localPart) throws NostrException {
        HttpResponse<String> response;
        URI uri;
        HttpClient client = this.httpClientProvider.create(this.connectTimeout);
        try {
            uri = new URI("https", null, host, port, "/.well-known/nostr.json", "name=" + URLEncoder.encode(localPart, StandardCharsets.UTF_8), null);
        }
        catch (URISyntaxException ex) {
            log.error("Validation error", ex);
            throw new NostrException("Invalid URI for host " + host + ": " + ex.getMessage());
        }
        HttpRequest request = HttpRequest.newBuilder().uri(uri).GET().timeout(this.requestTimeout).build();
        try {
            response = client.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException | InterruptedException ex) {
            if (ex instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            log.error("HTTP request error", ex);
            throw new NostrException(String.format("Error querying %s: %s", uri, ex.getMessage()));
        }
        if (response.statusCode() != 200) {
            throw new NostrException(String.format("Unexpected HTTP status %d from %s", response.statusCode(), uri));
        }
        String pubKey = this.getPublicKey(response.body(), localPart);
        log.debug("Public key for {} returned by the server: [{}]", (Object)localPart, (Object)pubKey);
        if (pubKey == null) {
            throw new NostrException(String.format("No NIP-05 record for '%s' at %s", localPart, uri));
        }
        if (!pubKey.equals(this.publicKey)) {
            throw new NostrException(String.format("Public key mismatch. Expected %s - Received: %s", this.publicKey, pubKey));
        }
    }

    private String getPublicKey(String content, String localPart) throws NostrException {
        Nip05Content nip05Content;
        try {
            nip05Content = MAPPER_BLACKBIRD.readValue(content, Nip05Content.class);
        }
        catch (IOException ex) {
            throw new NostrException("Invalid NIP-05 response: " + ex.getMessage());
        }
        Map<String, String> names = nip05Content.getNames();
        if (names == null) {
            return null;
        }
        return names.get(localPart);
    }

    @Generated
    private static Duration $default$connectTimeout() {
        return Duration.ofSeconds(5L);
    }

    @Generated
    private static Duration $default$requestTimeout() {
        return Duration.ofSeconds(5L);
    }

    @Generated
    private static HttpClientProvider $default$httpClientProvider() {
        return new DefaultHttpClientProvider();
    }

    @Generated
    public static Nip05ValidatorBuilder builder() {
        return new Nip05ValidatorBuilder();
    }

    @Generated
    public String getNip05() {
        return this.nip05;
    }

    @Generated
    public String getPublicKey() {
        return this.publicKey;
    }

    @Generated
    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    @Generated
    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    @Generated
    public HttpClientProvider getHttpClientProvider() {
        return this.httpClientProvider;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Nip05Validator)) {
            return false;
        }
        Nip05Validator other = (Nip05Validator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$nip05 = this.getNip05();
        String other$nip05 = other.getNip05();
        if (this$nip05 == null ? other$nip05 != null : !this$nip05.equals(other$nip05)) {
            return false;
        }
        String this$publicKey = this.getPublicKey();
        String other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        Duration this$connectTimeout = this.getConnectTimeout();
        Duration other$connectTimeout = other.getConnectTimeout();
        if (this$connectTimeout == null ? other$connectTimeout != null : !((Object)this$connectTimeout).equals(other$connectTimeout)) {
            return false;
        }
        Duration this$requestTimeout = this.getRequestTimeout();
        Duration other$requestTimeout = other.getRequestTimeout();
        if (this$requestTimeout == null ? other$requestTimeout != null : !((Object)this$requestTimeout).equals(other$requestTimeout)) {
            return false;
        }
        HttpClientProvider this$httpClientProvider = this.getHttpClientProvider();
        HttpClientProvider other$httpClientProvider = other.getHttpClientProvider();
        return !(this$httpClientProvider == null ? other$httpClientProvider != null : !this$httpClientProvider.equals(other$httpClientProvider));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Nip05Validator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $nip05 = this.getNip05();
        result = result * 59 + ($nip05 == null ? 43 : $nip05.hashCode());
        String $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        Duration $connectTimeout = this.getConnectTimeout();
        result = result * 59 + ($connectTimeout == null ? 43 : ((Object)$connectTimeout).hashCode());
        Duration $requestTimeout = this.getRequestTimeout();
        result = result * 59 + ($requestTimeout == null ? 43 : ((Object)$requestTimeout).hashCode());
        HttpClientProvider $httpClientProvider = this.getHttpClientProvider();
        result = result * 59 + ($httpClientProvider == null ? 43 : $httpClientProvider.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Nip05Validator(nip05=" + this.getNip05() + ", publicKey=" + this.getPublicKey() + ", connectTimeout=" + String.valueOf(this.getConnectTimeout()) + ", requestTimeout=" + String.valueOf(this.getRequestTimeout()) + ", httpClientProvider=" + String.valueOf(this.getHttpClientProvider()) + ")";
    }

    @Generated
    public Nip05Validator(String nip05, String publicKey, Duration connectTimeout, Duration requestTimeout, HttpClientProvider httpClientProvider) {
        this.nip05 = nip05;
        this.publicKey = publicKey;
        this.connectTimeout = connectTimeout;
        this.requestTimeout = requestTimeout;
        this.httpClientProvider = httpClientProvider;
    }

    @Generated
    public static class Nip05ValidatorBuilder {
        @Generated
        private String nip05;
        @Generated
        private String publicKey;
        @Generated
        private boolean connectTimeout$set;
        @Generated
        private Duration connectTimeout$value;
        @Generated
        private boolean requestTimeout$set;
        @Generated
        private Duration requestTimeout$value;
        @Generated
        private boolean httpClientProvider$set;
        @Generated
        private HttpClientProvider httpClientProvider$value;

        @Generated
        Nip05ValidatorBuilder() {
        }

        @Generated
        public Nip05ValidatorBuilder nip05(String nip05) {
            this.nip05 = nip05;
            return this;
        }

        @Generated
        public Nip05ValidatorBuilder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        @JsonIgnore
        @Generated
        public Nip05ValidatorBuilder connectTimeout(Duration connectTimeout) {
            this.connectTimeout$value = connectTimeout;
            this.connectTimeout$set = true;
            return this;
        }

        @JsonIgnore
        @Generated
        public Nip05ValidatorBuilder requestTimeout(Duration requestTimeout) {
            this.requestTimeout$value = requestTimeout;
            this.requestTimeout$set = true;
            return this;
        }

        @JsonIgnore
        @Generated
        public Nip05ValidatorBuilder httpClientProvider(HttpClientProvider httpClientProvider) {
            this.httpClientProvider$value = httpClientProvider;
            this.httpClientProvider$set = true;
            return this;
        }

        @Generated
        public Nip05Validator build() {
            Duration connectTimeout$value = this.connectTimeout$value;
            if (!this.connectTimeout$set) {
                connectTimeout$value = Nip05Validator.$default$connectTimeout();
            }
            Duration requestTimeout$value = this.requestTimeout$value;
            if (!this.requestTimeout$set) {
                requestTimeout$value = Nip05Validator.$default$requestTimeout();
            }
            HttpClientProvider httpClientProvider$value = this.httpClientProvider$value;
            if (!this.httpClientProvider$set) {
                httpClientProvider$value = Nip05Validator.$default$httpClientProvider();
            }
            return new Nip05Validator(this.nip05, this.publicKey, connectTimeout$value, requestTimeout$value, httpClientProvider$value);
        }

        @Generated
        public String toString() {
            return "Nip05Validator.Nip05ValidatorBuilder(nip05=" + this.nip05 + ", publicKey=" + this.publicKey + ", connectTimeout$value=" + String.valueOf(this.connectTimeout$value) + ", requestTimeout$value=" + String.valueOf(this.requestTimeout$value) + ", httpClientProvider$value=" + String.valueOf(this.httpClientProvider$value) + ")";
        }
    }
}

