/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator.jaspic;

import jakarta.security.auth.message.callback.CallerPrincipalCallback;
import jakarta.security.auth.message.callback.GroupPrincipalCallback;
import jakarta.security.auth.message.callback.PasswordValidationCallback;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.catalina.Contained;
import org.apache.catalina.Container;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class CallbackHandlerImpl
implements CallbackHandler,
Contained {
    private static final StringManager sm = StringManager.getManager(CallbackHandlerImpl.class);
    private final Log log = LogFactory.getLog(CallbackHandlerImpl.class);
    private Container container;

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        String name = null;
        Principal principal2 = null;
        Subject subject = null;
        String[] groups2 = null;
        if (callbacks != null) {
            for (Callback callback : callbacks) {
                if (callback instanceof CallerPrincipalCallback) {
                    CallerPrincipalCallback cpc = (CallerPrincipalCallback)callback;
                    name = cpc.getName();
                    if (cpc.getPrincipal() != null) {
                        principal2 = cpc.getPrincipal();
                    }
                    subject = cpc.getSubject();
                    continue;
                }
                if (callback instanceof GroupPrincipalCallback) {
                    GroupPrincipalCallback gpc = (GroupPrincipalCallback)callback;
                    groups2 = gpc.getGroups();
                    continue;
                }
                if (callback instanceof PasswordValidationCallback) {
                    if (this.container == null) {
                        this.log.warn(sm.getString("callbackHandlerImpl.containerMissing", callback.getClass().getName()));
                        continue;
                    }
                    if (this.container.getRealm() == null) {
                        this.log.warn(sm.getString("callbackHandlerImpl.realmMissing", callback.getClass().getName(), this.container.getName()));
                        continue;
                    }
                    PasswordValidationCallback pvc = (PasswordValidationCallback)callback;
                    principal2 = this.container.getRealm().authenticate(pvc.getUsername(), String.valueOf(pvc.getPassword()));
                    pvc.setResult(principal2 != null);
                    subject = pvc.getSubject();
                    continue;
                }
                this.log.error(sm.getString("callbackHandlerImpl.jaspicCallbackMissing", callback.getClass().getName()));
            }
            if (subject != null) {
                if (name == null && principal2 != null) {
                    name = principal2.getName();
                }
                if (name != null) {
                    if (principal2 instanceof GenericPrincipal) {
                        subject.getPrivateCredentials().add(principal2);
                    } else {
                        ArrayList<String> mergedRoles = new ArrayList<String>();
                        Set<GenericPrincipal> gps = subject.getPrivateCredentials(GenericPrincipal.class);
                        if (!gps.isEmpty()) {
                            GenericPrincipal gp = gps.iterator().next();
                            mergedRoles.addAll(Arrays.asList(gp.getRoles()));
                            subject.getPrivateCredentials().remove(gp);
                        }
                        if (groups2 != null) {
                            mergedRoles.addAll(Arrays.asList(groups2));
                        }
                        if (mergedRoles.isEmpty()) {
                            mergedRoles = Collections.emptyList();
                        }
                        subject.getPrivateCredentials().add(new GenericPrincipal(name, mergedRoles, principal2));
                    }
                }
            }
        }
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        this.container = container;
    }
}

