/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.ConstantMethodHandle;
import org.aspectj.apache.bcel.classfile.ConstantPool;

public final class BootstrapMethods
extends Attribute {
    private boolean isInPackedState = false;
    private byte[] data;
    private int numBootstrapMethods;
    private BootstrapMethod[] bootstrapMethods;

    public BootstrapMethods(BootstrapMethods c) {
        this(c.getNameIndex(), c.getLength(), c.getBootstrapMethods(), c.getConstantPool());
    }

    public BootstrapMethods(int nameIndex, int length, BootstrapMethod[] lineNumberTable, ConstantPool constantPool) {
        super((byte)19, nameIndex, length, constantPool);
        this.setBootstrapMethods(lineNumberTable);
        this.isInPackedState = false;
    }

    public final void setBootstrapMethods(BootstrapMethod[] bootstrapMethods) {
        this.data = null;
        this.isInPackedState = false;
        this.bootstrapMethods = bootstrapMethods;
        this.numBootstrapMethods = bootstrapMethods == null ? 0 : bootstrapMethods.length;
    }

    BootstrapMethods(int name_index, int length, DataInputStream file, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (BootstrapMethod[])null, constant_pool);
        this.data = new byte[length];
        file.readFully(this.data);
        this.isInPackedState = true;
    }

    private void unpack() {
        if (this.isInPackedState) {
            try {
                ByteArrayInputStream bs = new ByteArrayInputStream(this.data);
                DataInputStream dis = new DataInputStream(bs);
                this.numBootstrapMethods = dis.readUnsignedShort();
                this.bootstrapMethods = new BootstrapMethod[this.numBootstrapMethods];
                for (int i2 = 0; i2 < this.numBootstrapMethods; ++i2) {
                    this.bootstrapMethods[i2] = new BootstrapMethod(dis);
                }
                dis.close();
                this.data = null;
            }
            catch (IOException e) {
                throw new RuntimeException("Unpacking of LineNumberTable attribute failed");
            }
            this.isInPackedState = false;
        }
    }

    @Override
    public void accept(ClassVisitor v) {
        this.unpack();
        v.visitBootstrapMethods(this);
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        if (this.isInPackedState) {
            file.write(this.data);
        } else {
            int blen = this.bootstrapMethods.length;
            file.writeShort(blen);
            for (BootstrapMethod bootstrapMethod : this.bootstrapMethods) {
                bootstrapMethod.dump(file);
            }
        }
    }

    public final BootstrapMethod[] getBootstrapMethods() {
        this.unpack();
        return this.bootstrapMethods;
    }

    @Override
    public final String toString() {
        this.unpack();
        StringBuilder buf = new StringBuilder();
        StringBuilder line = new StringBuilder();
        for (int i2 = 0; i2 < this.numBootstrapMethods; ++i2) {
            BootstrapMethod bm = this.bootstrapMethods[i2];
            line.append("BootstrapMethod[").append(i2).append("]:");
            int ref = bm.getBootstrapMethodRef();
            ConstantMethodHandle mh = (ConstantMethodHandle)this.getConstantPool().getConstant(ref);
            line.append("#" + ref + ":");
            line.append(ConstantMethodHandle.kindToString(mh.getReferenceKind()));
            line.append(" ").append(this.getConstantPool().getConstant(mh.getReferenceIndex()));
            int[] args2 = bm.getBootstrapArguments();
            line.append(" argcount:").append(args2 == null ? 0 : args2.length).append(" ");
            if (args2 != null) {
                for (int arg : args2) {
                    line.append(arg).append("(").append(this.getConstantPool().getConstant(arg)).append(") ");
                }
            }
            if (i2 < this.numBootstrapMethods - 1) {
                line.append(", ");
            }
            if (line.length() <= 72) continue;
            line.append('\n');
            buf.append((CharSequence)line);
            line.setLength(0);
        }
        buf.append((CharSequence)line);
        return buf.toString();
    }

    public final int getNumBootstrapMethods() {
        this.unpack();
        return this.bootstrapMethods.length;
    }

    public static class BootstrapMethod {
        private int bootstrapMethodRef;
        private int[] bootstrapArguments;

        BootstrapMethod(DataInputStream file) throws IOException {
            this(file.readUnsignedShort(), BootstrapMethod.readBootstrapArguments(file));
        }

        private static int[] readBootstrapArguments(DataInputStream dis) throws IOException {
            int numBootstrapMethods = dis.readUnsignedShort();
            int[] bootstrapArguments = new int[numBootstrapMethods];
            for (int i2 = 0; i2 < numBootstrapMethods; ++i2) {
                bootstrapArguments[i2] = dis.readUnsignedShort();
            }
            return bootstrapArguments;
        }

        public BootstrapMethod(int bootstrapMethodRef, int[] bootstrapArguments) {
            this.bootstrapMethodRef = bootstrapMethodRef;
            this.bootstrapArguments = bootstrapArguments;
        }

        public int getBootstrapMethodRef() {
            return this.bootstrapMethodRef;
        }

        public int[] getBootstrapArguments() {
            return this.bootstrapArguments;
        }

        public final void dump(DataOutputStream file) throws IOException {
            file.writeShort(this.bootstrapMethodRef);
            int len = this.bootstrapArguments.length;
            file.writeShort(len);
            for (int bootstrapArgument : this.bootstrapArguments) {
                file.writeShort(bootstrapArgument);
            }
        }

        public final int getLength() {
            return 4 + 2 * this.bootstrapArguments.length;
        }
    }
}

