/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.Utility;

public final class ExceptionTable
extends Attribute {
    private int number_of_exceptions;
    private int[] exception_index_table;

    public ExceptionTable(ExceptionTable c) {
        this(c.getNameIndex(), c.getLength(), c.getExceptionIndexTable(), c.getConstantPool());
    }

    public ExceptionTable(int name_index, int length, int[] exception_index_table, ConstantPool constant_pool) {
        super((byte)3, name_index, length, constant_pool);
        this.setExceptionIndexTable(exception_index_table);
    }

    ExceptionTable(int name_index, int length, DataInputStream file, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (int[])null, constant_pool);
        this.number_of_exceptions = file.readUnsignedShort();
        this.exception_index_table = new int[this.number_of_exceptions];
        for (int i2 = 0; i2 < this.number_of_exceptions; ++i2) {
            this.exception_index_table[i2] = file.readUnsignedShort();
        }
    }

    @Override
    public void accept(ClassVisitor v) {
        v.visitExceptionTable(this);
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.number_of_exceptions);
        for (int i2 = 0; i2 < this.number_of_exceptions; ++i2) {
            file.writeShort(this.exception_index_table[i2]);
        }
    }

    public final int[] getExceptionIndexTable() {
        return this.exception_index_table;
    }

    public final int getNumberOfExceptions() {
        return this.number_of_exceptions;
    }

    public final String[] getExceptionNames() {
        String[] names = new String[this.number_of_exceptions];
        for (int i2 = 0; i2 < this.number_of_exceptions; ++i2) {
            names[i2] = this.cpool.getConstantString(this.exception_index_table[i2], (byte)7).replace('/', '.');
        }
        return names;
    }

    public final void setExceptionIndexTable(int[] exception_index_table) {
        this.exception_index_table = exception_index_table;
        this.number_of_exceptions = exception_index_table == null ? 0 : exception_index_table.length;
    }

    @Override
    public final String toString() {
        StringBuilder buf = new StringBuilder("");
        for (int i2 = 0; i2 < this.number_of_exceptions; ++i2) {
            String str = this.cpool.getConstantString(this.exception_index_table[i2], (byte)7);
            buf.append(Utility.compactClassName(str, false));
            if (i2 >= this.number_of_exceptions - 1) continue;
            buf.append(", ");
        }
        return buf.toString();
    }
}

