/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.asm.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.IRelationship;
import org.aspectj.asm.IRelationshipMap;
import org.aspectj.asm.internal.Relationship;

public class RelationshipMap
extends HashMap<String, List<IRelationship>>
implements IRelationshipMap {
    private static final long serialVersionUID = 496638323566589643L;

    @Override
    public List<IRelationship> get(String handle2) {
        List relationships = (List)super.get(handle2);
        if (relationships == null) {
            return null;
        }
        return relationships;
    }

    @Override
    public List<IRelationship> get(IProgramElement source2) {
        return this.get(source2.getHandleIdentifier());
    }

    @Override
    public IRelationship get(String source2, IRelationship.Kind kind, String relationshipName, boolean runtimeTest, boolean createIfMissing) {
        List<IRelationship> relationships = this.get(source2);
        if (relationships == null) {
            if (!createIfMissing) {
                return null;
            }
            relationships = new ArrayList<IRelationship>();
            Relationship rel = new Relationship(relationshipName, kind, source2, new ArrayList<String>(), runtimeTest);
            relationships.add(rel);
            super.put(source2, relationships);
            return rel;
        }
        for (IRelationship curr : relationships) {
            if (curr.getKind() != kind || !curr.getName().equals(relationshipName) || curr.hasRuntimeTest() != runtimeTest) continue;
            return curr;
        }
        if (createIfMissing) {
            Relationship rel = new Relationship(relationshipName, kind, source2, new ArrayList<String>(), runtimeTest);
            relationships.add(rel);
            return rel;
        }
        return null;
    }

    @Override
    public IRelationship get(IProgramElement source2, IRelationship.Kind kind, String relationshipName, boolean runtimeTest, boolean createIfMissing) {
        return this.get(source2.getHandleIdentifier(), kind, relationshipName, runtimeTest, createIfMissing);
    }

    @Override
    public IRelationship get(IProgramElement source2, IRelationship.Kind kind, String relationshipName) {
        return this.get(source2, kind, relationshipName, false, true);
    }

    @Override
    public boolean remove(String source2, IRelationship relationship) {
        List list = (List)super.get(source2);
        if (list != null) {
            return list.remove(relationship);
        }
        return false;
    }

    @Override
    public void removeAll(String source2) {
        super.remove(source2);
    }

    @Override
    public void put(String source2, IRelationship relationship) {
        ArrayList<IRelationship> existingRelationships = (ArrayList<IRelationship>)super.get(source2);
        if (existingRelationships == null) {
            existingRelationships = new ArrayList<IRelationship>();
            existingRelationships.add(relationship);
            super.put(source2, existingRelationships);
        } else {
            boolean matched = false;
            for (IRelationship existingRelationship : existingRelationships) {
                if (!existingRelationship.getName().equals(relationship.getName()) || existingRelationship.getKind() != relationship.getKind()) continue;
                existingRelationship.getTargets().addAll(relationship.getTargets());
                matched = true;
            }
            if (matched) {
                System.err.println("matched = true");
            }
            if (matched) {
                existingRelationships.add(relationship);
            }
        }
    }

    @Override
    public void put(IProgramElement source2, IRelationship relationship) {
        this.put(source2.getHandleIdentifier(), relationship);
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public Set<String> getEntries() {
        return this.keySet();
    }
}

