/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.base;

import java.util.Comparator;
import javax.annotation.Nullable;
import org.bitcoinj.base.AddressParser;
import org.bitcoinj.base.LegacyAddress;
import org.bitcoinj.base.Network;
import org.bitcoinj.base.ScriptType;
import org.bitcoinj.base.SegwitAddress;
import org.bitcoinj.base.exceptions.AddressFormatException;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.crypto.ECKey;

public interface Address
extends Comparable<Address> {
    public static final Comparator<Address> PARTIAL_ADDRESS_COMPARATOR = Comparator.comparing(a -> a.network().id()).thenComparing(Address::compareTypes);

    @Deprecated
    public static Address fromString(@Nullable NetworkParameters params, String str) throws AddressFormatException {
        return AddressParser.getLegacy(params).parseAddress(str);
    }

    @Deprecated
    public static Address fromKey(NetworkParameters params, ECKey key, ScriptType outputScriptType) {
        return key.toAddress(outputScriptType, params.network());
    }

    @Deprecated
    default public NetworkParameters getParameters() {
        return NetworkParameters.of(this.network());
    }

    public byte[] getHash();

    public ScriptType getOutputScriptType();

    @Override
    public int compareTo(Address var1);

    public Network network();

    public static int compareTypes(Address a, Address b) {
        if (a instanceof LegacyAddress && b instanceof SegwitAddress) {
            return -1;
        }
        if (a instanceof SegwitAddress && b instanceof LegacyAddress) {
            return 1;
        }
        return 0;
    }
}

