/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.base;

import javax.annotation.Nullable;
import org.bitcoinj.base.Address;
import org.bitcoinj.base.DefaultAddressParserProvider;
import org.bitcoinj.base.Network;
import org.bitcoinj.base.exceptions.AddressFormatException;
import org.bitcoinj.core.NetworkParameters;

@FunctionalInterface
public interface AddressParser {
    public Address parseAddress(String var1) throws AddressFormatException;

    public static AddressParser getDefault() {
        return new DefaultAddressParserProvider().forKnownNetworks();
    }

    public static AddressParser getDefault(Network network) {
        return new DefaultAddressParserProvider().forNetwork(network);
    }

    @Deprecated
    public static AddressParser getLegacy() {
        return DefaultAddressParserProvider.fromNetworks().forKnownNetworks();
    }

    @Deprecated
    public static AddressParser getLegacy(Network network) {
        return DefaultAddressParserProvider.fromNetworks().forNetwork(network);
    }

    @Deprecated
    public static AddressParser getLegacy(@Nullable NetworkParameters params) {
        DefaultAddressParserProvider provider = DefaultAddressParserProvider.fromNetworks();
        return params == null ? provider.forKnownNetworks() : provider.forNetwork(params.network());
    }

    public static interface AddressParserProvider {
        public AddressParser forKnownNetworks();

        public AddressParser forNetwork(Network var1);
    }
}

