/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.base;

import java.math.BigInteger;
import java.util.Arrays;
import org.bitcoinj.base.Sha256Hash;
import org.bitcoinj.base.exceptions.AddressFormatException;
import org.bitcoinj.base.internal.ByteUtils;

public class Base58 {
    public static final char[] ALPHABET = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz".toCharArray();
    private static final char ENCODED_ZERO = ALPHABET[0];
    private static final int[] INDEXES = new int[128];

    public static String encode(byte[] input) {
        int zeros;
        if (input.length == 0) {
            return "";
        }
        for (zeros = 0; zeros < input.length && input[zeros] == 0; ++zeros) {
        }
        input = Arrays.copyOf(input, input.length);
        char[] encoded = new char[input.length * 2];
        int outputStart = encoded.length;
        int inputStart = zeros;
        while (inputStart < input.length) {
            encoded[--outputStart] = ALPHABET[Base58.divmod(input, inputStart, 256, 58)];
            if (input[inputStart] != 0) continue;
            ++inputStart;
        }
        while (outputStart < encoded.length && encoded[outputStart] == ENCODED_ZERO) {
            ++outputStart;
        }
        while (--zeros >= 0) {
            encoded[--outputStart] = ENCODED_ZERO;
        }
        return new String(encoded, outputStart, encoded.length - outputStart);
    }

    public static String encodeChecked(int version, byte[] payload) {
        if (version < 0 || version > 255) {
            throw new IllegalArgumentException("Version not in range.");
        }
        byte[] addressBytes = new byte[1 + payload.length + 4];
        addressBytes[0] = (byte)version;
        System.arraycopy(payload, 0, addressBytes, 1, payload.length);
        byte[] checksum = Sha256Hash.hashTwice(addressBytes, 0, payload.length + 1);
        System.arraycopy(checksum, 0, addressBytes, payload.length + 1, 4);
        return Base58.encode(addressBytes);
    }

    public static byte[] decode(String input) throws AddressFormatException {
        int zeros;
        if (input.length() == 0) {
            return new byte[0];
        }
        byte[] input58 = new byte[input.length()];
        for (int i2 = 0; i2 < input.length(); ++i2) {
            int digit;
            char c = input.charAt(i2);
            int n = digit = c < '\u0080' ? INDEXES[c] : -1;
            if (digit < 0) {
                throw new AddressFormatException.InvalidCharacter(c, i2);
            }
            input58[i2] = (byte)digit;
        }
        for (zeros = 0; zeros < input58.length && input58[zeros] == 0; ++zeros) {
        }
        byte[] decoded = new byte[input.length()];
        int outputStart = decoded.length;
        int inputStart = zeros;
        while (inputStart < input58.length) {
            decoded[--outputStart] = Base58.divmod(input58, inputStart, 58, 256);
            if (input58[inputStart] != 0) continue;
            ++inputStart;
        }
        while (outputStart < decoded.length && decoded[outputStart] == 0) {
            ++outputStart;
        }
        return Arrays.copyOfRange(decoded, outputStart - zeros, decoded.length);
    }

    public static BigInteger decodeToBigInteger(String input) throws AddressFormatException {
        return ByteUtils.bytesToBigInteger(Base58.decode(input));
    }

    public static byte[] decodeChecked(String input) throws AddressFormatException {
        byte[] actualChecksum;
        byte[] decoded = Base58.decode(input);
        if (decoded.length < 4) {
            throw new AddressFormatException.InvalidDataLength("Input too short: " + decoded.length);
        }
        byte[] data = Arrays.copyOfRange(decoded, 0, decoded.length - 4);
        byte[] checksum = Arrays.copyOfRange(decoded, decoded.length - 4, decoded.length);
        if (!Arrays.equals(checksum, actualChecksum = Arrays.copyOfRange(Sha256Hash.hashTwice(data), 0, 4))) {
            throw new AddressFormatException.InvalidChecksum();
        }
        return data;
    }

    private static byte divmod(byte[] number, int firstDigit, int base, int divisor) {
        int remainder = 0;
        for (int i2 = firstDigit; i2 < number.length; ++i2) {
            int digit = number[i2] & 0xFF;
            int temp = remainder * base + digit;
            number[i2] = (byte)(temp / divisor);
            remainder = temp % divisor;
        }
        return (byte)remainder;
    }

    static {
        Arrays.fill(INDEXES, -1);
        for (int i2 = 0; i2 < ALPHABET.length; ++i2) {
            Base58.INDEXES[Base58.ALPHABET[i2]] = i2;
        }
    }
}

