/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.base;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.Locale;
import javax.annotation.Nullable;
import org.bitcoinj.base.exceptions.AddressFormatException;
import org.bitcoinj.base.internal.ByteArray;
import org.bitcoinj.base.internal.Preconditions;

public class Bech32 {
    private static final String CHARSET = "qpzry9x8gf2tvdw0s3jn54khce6mua7l";
    private static final byte[] CHARSET_REV = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 15, -1, 10, 17, 21, 20, 26, 30, 7, 5, -1, -1, -1, -1, -1, -1, -1, 29, -1, 24, 13, 25, 9, 8, 23, -1, 18, 22, 31, 27, 19, -1, 1, 0, 3, 16, 11, 28, 12, 14, 6, 4, 2, -1, -1, -1, -1, -1, -1, 29, -1, 24, 13, 25, 9, 8, 23, -1, 18, 22, 31, 27, 19, -1, 1, 0, 3, 16, 11, 28, 12, 14, 6, 4, 2, -1, -1, -1, -1, -1};
    private static final int BECH32_CONST = 1;
    private static final int BECH32M_CONST = 734539939;

    private static int polymod(byte[] values2) {
        int c = 1;
        for (byte v_i : values2) {
            int c0 = c >>> 25 & 0xFF;
            c = (c & 0x1FFFFFF) << 5 ^ v_i & 0xFF;
            if ((c0 & 1) != 0) {
                c ^= 0x3B6A57B2;
            }
            if ((c0 & 2) != 0) {
                c ^= 0x26508E6D;
            }
            if ((c0 & 4) != 0) {
                c ^= 0x1EA119FA;
            }
            if ((c0 & 8) != 0) {
                c ^= 0x3D4233DD;
            }
            if ((c0 & 0x10) == 0) continue;
            c ^= 0x2A1462B3;
        }
        return c;
    }

    private static byte[] expandHrp(String hrp) {
        int hrpLength = hrp.length();
        byte[] ret = new byte[hrpLength * 2 + 1];
        for (int i2 = 0; i2 < hrpLength; ++i2) {
            int c = hrp.charAt(i2) & 0x7F;
            ret[i2] = (byte)(c >>> 5 & 7);
            ret[i2 + hrpLength + 1] = (byte)(c & 0x1F);
        }
        ret[hrpLength] = 0;
        return ret;
    }

    @Nullable
    private static Encoding verifyChecksum(String hrp, byte[] values2) {
        byte[] hrpExpanded = Bech32.expandHrp(hrp);
        byte[] combined = new byte[hrpExpanded.length + values2.length];
        System.arraycopy(hrpExpanded, 0, combined, 0, hrpExpanded.length);
        System.arraycopy(values2, 0, combined, hrpExpanded.length, values2.length);
        int check2 = Bech32.polymod(combined);
        if (check2 == 1) {
            return Encoding.BECH32;
        }
        if (check2 == 734539939) {
            return Encoding.BECH32M;
        }
        return null;
    }

    private static byte[] createChecksum(Encoding encoding, String hrp, byte[] values2) {
        byte[] hrpExpanded = Bech32.expandHrp(hrp);
        byte[] enc = new byte[hrpExpanded.length + values2.length + 6];
        System.arraycopy(hrpExpanded, 0, enc, 0, hrpExpanded.length);
        System.arraycopy(values2, 0, enc, hrpExpanded.length, values2.length);
        int mod = Bech32.polymod(enc) ^ (encoding == Encoding.BECH32 ? 1 : 734539939);
        byte[] ret = new byte[6];
        for (int i2 = 0; i2 < 6; ++i2) {
            ret[i2] = (byte)(mod >>> 5 * (5 - i2) & 0x1F);
        }
        return ret;
    }

    public static String encodeBytes(Encoding encoding, String hrp, byte[] bytes) {
        return Bech32.encode(encoding, hrp, Bech32Bytes.ofBytes(bytes));
    }

    public static byte[] decodeBytes(String bech32, String expectedHrp, Encoding expectedEncoding) {
        Bech32Data decoded = Bech32.decode(bech32);
        if (!decoded.hrp.equals(expectedHrp) || decoded.encoding != expectedEncoding) {
            throw new AddressFormatException("unexpected hrp or encoding");
        }
        return decoded.decode5to8();
    }

    public static String encode(Bech32Data bech32) {
        return Bech32.encode(bech32.encoding, bech32.hrp, bech32);
    }

    public static String encode(Encoding encoding, String hrp, Bech32Bytes values2) {
        Preconditions.checkArgument(hrp.length() >= 1, () -> "human-readable part is too short: " + hrp.length());
        Preconditions.checkArgument(hrp.length() <= 83, () -> "human-readable part is too long: " + hrp.length());
        String lcHrp = hrp.toLowerCase(Locale.ROOT);
        byte[] checksum = Bech32.createChecksum(encoding, lcHrp, values2.bytes());
        byte[] combined = new byte[values2.bytes().length + checksum.length];
        System.arraycopy(values2.bytes(), 0, combined, 0, values2.bytes().length);
        System.arraycopy(checksum, 0, combined, values2.bytes().length, checksum.length);
        StringBuilder sb = new StringBuilder(lcHrp.length() + 1 + combined.length);
        sb.append(lcHrp);
        sb.append('1');
        for (byte b : combined) {
            sb.append(CHARSET.charAt(b));
        }
        return sb.toString();
    }

    public static Bech32Data decode(String str) throws AddressFormatException {
        boolean lower = false;
        boolean upper = false;
        if (str.length() < 8) {
            throw new AddressFormatException.InvalidDataLength("Input too short: " + str.length());
        }
        if (str.length() > 90) {
            throw new AddressFormatException.InvalidDataLength("Input too long: " + str.length());
        }
        for (int i2 = 0; i2 < str.length(); ++i2) {
            char c = str.charAt(i2);
            if (c < '!' || c > '~') {
                throw new AddressFormatException.InvalidCharacter(c, i2);
            }
            if (c >= 'a' && c <= 'z') {
                if (upper) {
                    throw new AddressFormatException.InvalidCharacter(c, i2);
                }
                lower = true;
            }
            if (c < 'A' || c > 'Z') continue;
            if (lower) {
                throw new AddressFormatException.InvalidCharacter(c, i2);
            }
            upper = true;
        }
        int pos = str.lastIndexOf(49);
        if (pos < 1) {
            throw new AddressFormatException.InvalidPrefix("Missing human-readable part");
        }
        int dataPartLength = str.length() - 1 - pos;
        if (dataPartLength < 6) {
            throw new AddressFormatException.InvalidDataLength("Data part too short: " + dataPartLength);
        }
        byte[] values2 = new byte[dataPartLength];
        for (int i3 = 0; i3 < dataPartLength; ++i3) {
            char c = str.charAt(i3 + pos + 1);
            if (CHARSET_REV[c] == -1) {
                throw new AddressFormatException.InvalidCharacter(c, i3 + pos + 1);
            }
            values2[i3] = CHARSET_REV[c];
        }
        String hrp = str.substring(0, pos).toLowerCase(Locale.ROOT);
        Encoding encoding = Bech32.verifyChecksum(hrp, values2);
        if (encoding == null) {
            throw new AddressFormatException.InvalidChecksum();
        }
        return new Bech32Data(encoding, hrp, Arrays.copyOfRange(values2, 0, values2.length - 6));
    }

    private static byte[] convertBits(byte[] in, int inStart, int inLen, int fromBits, int toBits, boolean pad) throws AddressFormatException {
        int acc = 0;
        int bits = 0;
        ByteArrayOutputStream out = new ByteArrayOutputStream(64);
        int maxv = (1 << toBits) - 1;
        int max_acc = (1 << fromBits + toBits - 1) - 1;
        for (int i2 = 0; i2 < inLen; ++i2) {
            int value = in[i2 + inStart] & 0xFF;
            if (value >>> fromBits != 0) {
                throw new AddressFormatException(String.format("Input value '%X' exceeds '%d' bit size", value, fromBits));
            }
            acc = (acc << fromBits | value) & max_acc;
            bits += fromBits;
            while (bits >= toBits) {
                out.write(acc >>> (bits -= toBits) & maxv);
            }
        }
        if (pad) {
            if (bits > 0) {
                out.write(acc << toBits - bits & maxv);
            }
        } else if (bits >= fromBits || (acc << toBits - bits & maxv) != 0) {
            throw new AddressFormatException("Could not convert bits, invalid padding");
        }
        return out.toByteArray();
    }

    public static enum Encoding {
        BECH32,
        BECH32M;

    }

    public static class Bech32Bytes
    extends ByteArray {
        protected Bech32Bytes(byte[] bytes) {
            super(bytes);
        }

        private Bech32Bytes(byte first, byte[] rest) {
            super(Bech32Bytes.concat(first, rest));
        }

        private static byte[] concat(byte first, byte[] rest) {
            byte[] bytes = new byte[rest.length + 1];
            bytes[0] = first;
            System.arraycopy(rest, 0, bytes, 1, rest.length);
            return bytes;
        }

        static Bech32Bytes ofBytes(byte[] data) {
            return new Bech32Bytes(Bech32Bytes.encode8to5(data));
        }

        static Bech32Bytes ofSegwit(short witnessVersion, byte[] witnessProgram) {
            return new Bech32Bytes((byte)(witnessVersion & 0xFF), Bech32Bytes.encode8to5(witnessProgram));
        }

        private static byte[] encode8to5(byte[] data) {
            return Bech32.convertBits(data, 0, data.length, 8, 5, true);
        }

        public byte[] decode5to8() {
            return Bech32.convertBits(this.bytes, 0, this.bytes.length, 5, 8, false);
        }

        short witnessVersion() {
            return this.bytes[0];
        }

        private Bech32Bytes stripFirst() {
            byte[] program = new byte[this.bytes.length - 1];
            System.arraycopy(this.bytes, 1, program, 0, program.length);
            return new Bech32Bytes(program);
        }

        byte[] witnessProgram() {
            return this.stripFirst().decode5to8();
        }
    }

    public static class Bech32Data
    extends Bech32Bytes {
        public final Encoding encoding;
        public final String hrp;

        private Bech32Data(Encoding encoding, String hrp, byte[] data) {
            super(data);
            this.encoding = encoding;
            this.hrp = hrp;
        }
    }
}

