/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bitcoinj.base.Address;
import org.bitcoinj.base.Coin;
import org.bitcoinj.base.LegacyAddress;
import org.bitcoinj.base.Monetary;
import org.bitcoinj.base.Network;
import org.bitcoinj.base.SegwitAddress;

public enum BitcoinNetwork implements Network
{
    MAINNET("org.bitcoin.production", "main", "prod"),
    TESTNET("org.bitcoin.test", "test"),
    SIGNET("org.bitcoin.signet", "sig"),
    REGTEST("org.bitcoin.regtest", new String[0]);

    public static final String BITCOIN_SCHEME = "bitcoin";
    private static final long MAX_COINS = 21000000L;
    public static final Coin MAX_MONEY;
    public static final String ID_MAINNET;
    public static final String ID_TESTNET;
    public static final String ID_SIGNET;
    public static final String ID_REGTEST;
    private final String id;
    private final List<String> allNames;
    private static final Map<String, BitcoinNetwork> stringToEnum;

    private BitcoinNetwork(String networkId, String ... alternateNames) {
        this.id = networkId;
        this.allNames = BitcoinNetwork.combine(this.toString(), alternateNames);
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public int legacyAddressHeader() {
        return LegacyAddress.AddressHeader.ofNetwork(this).headerByte();
    }

    @Override
    public int legacyP2SHHeader() {
        return LegacyAddress.P2SHHeader.ofNetwork(this).headerByte();
    }

    @Override
    public String segwitAddressHrp() {
        return SegwitAddress.SegwitHrp.ofNetwork(this).toString();
    }

    @Override
    public String uriScheme() {
        return BITCOIN_SCHEME;
    }

    @Override
    public boolean hasMaxMoney() {
        return true;
    }

    @Override
    public Coin maxMoney() {
        return MAX_MONEY;
    }

    @Override
    public boolean exceedsMaxMoney(Monetary amount) {
        if (amount instanceof Coin) {
            return ((Coin)amount).compareTo(MAX_MONEY) > 0;
        }
        throw new IllegalArgumentException("amount must be a Coin type");
    }

    public Address checkAddress(Address address) throws IllegalArgumentException {
        if (!this.isValidAddress(address)) {
            throw new IllegalArgumentException(String.format("Address %s not valid on network %s", address, this));
        }
        return address;
    }

    public boolean isValidAddress(Address address) {
        boolean valid;
        switch (this) {
            case MAINNET: {
                valid = address.network() == MAINNET;
                break;
            }
            case TESTNET: 
            case SIGNET: {
                valid = address.network() == TESTNET;
                break;
            }
            case REGTEST: {
                if (address instanceof LegacyAddress) {
                    valid = ((LegacyAddress)address).network == TESTNET;
                    break;
                }
                valid = address.network() == REGTEST;
                break;
            }
            default: {
                valid = false;
            }
        }
        return valid;
    }

    public static Optional<BitcoinNetwork> fromString(String nameString) {
        return Optional.ofNullable(stringToEnum.get(nameString));
    }

    public static Optional<BitcoinNetwork> fromIdString(String idString) {
        return BitcoinNetwork.stream().filter(n -> n.id.equals(idString)).findFirst();
    }

    public static List<String> strings() {
        return BitcoinNetwork.stream().map(BitcoinNetwork::toString).collect(Collectors.toList());
    }

    private static Stream<BitcoinNetwork> stream() {
        return Arrays.stream(BitcoinNetwork.values());
    }

    private static Map<String, BitcoinNetwork> mergedNameMap() {
        return BitcoinNetwork.stream().collect(HashMap::new, BitcoinNetwork::accumulateNames, Map::putAll);
    }

    private static void accumulateNames(Map<String, BitcoinNetwork> map, BitcoinNetwork net) {
        net.allNames.forEach(name -> map.put((String)name, net));
    }

    private static List<String> combine(String canonical, String[] alternateNames) {
        ArrayList<String> temp = new ArrayList<String>();
        temp.add(canonical);
        temp.addAll(Arrays.asList(alternateNames));
        return Collections.unmodifiableList(temp);
    }

    static {
        MAX_MONEY = Coin.COIN.multiply(21000000L);
        ID_MAINNET = MAINNET.id();
        ID_TESTNET = TESTNET.id();
        ID_SIGNET = SIGNET.id();
        ID_REGTEST = REGTEST.id();
        stringToEnum = BitcoinNetwork.mergedNameMap();
    }
}

