/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.base;

import java.math.BigDecimal;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.bitcoinj.base.Monetary;
import org.bitcoinj.base.internal.Preconditions;
import org.bitcoinj.base.utils.MonetaryFormat;

public final class Coin
implements Monetary,
Comparable<Coin> {
    public static final int SMALLEST_UNIT_EXPONENT = 8;
    private static final long COIN_VALUE = 100000000L;
    public static final Coin ZERO = new Coin(0L);
    public static final Coin COIN = Coin.valueOf(100000000L);
    public static final Coin CENT = COIN.divide(100L);
    public static final Coin MILLICOIN = COIN.divide(1000L);
    public static final Coin MICROCOIN = MILLICOIN.divide(1000L);
    public static final Coin SATOSHI = Coin.valueOf(1L);
    public static final Coin FIFTY_COINS = COIN.multiply(50L);
    public static final Coin NEGATIVE_SATOSHI = Coin.valueOf(-1L);
    public static final int BYTES = 8;
    public final long value;
    private static final MonetaryFormat FRIENDLY_FORMAT = MonetaryFormat.BTC.minDecimals(2).repeatOptionalDecimals(1, 6).postfixCode();
    private static final MonetaryFormat PLAIN_FORMAT = MonetaryFormat.BTC.minDecimals(0).repeatOptionalDecimals(1, 8).noCode();

    private Coin(long satoshis) {
        this.value = satoshis;
    }

    public static Coin valueOf(long satoshis) {
        return satoshis == 0L ? ZERO : new Coin(satoshis);
    }

    public static Coin read(ByteBuffer buf) throws BufferUnderflowException {
        return Coin.valueOf(buf.order(ByteOrder.LITTLE_ENDIAN).getLong());
    }

    @Override
    public int smallestUnitExponent() {
        return 8;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    public static Coin valueOf(int coins, int cents) {
        Preconditions.checkArgument(cents < 100, () -> "cents nust be below 100: " + cents);
        Preconditions.checkArgument(cents >= 0, () -> "cents cannot be negative: " + cents);
        Preconditions.checkArgument(coins >= 0, () -> "coins cannot be negative: " + cents);
        Coin coin = COIN.multiply(coins).add(CENT.multiply(cents));
        return coin;
    }

    public static long btcToSatoshi(BigDecimal coins) throws ArithmeticException {
        return coins.movePointRight(8).longValueExact();
    }

    public static BigDecimal satoshiToBtc(long satoshis) {
        return new BigDecimal(satoshis).movePointLeft(8);
    }

    public static Coin ofBtc(BigDecimal coins) throws ArithmeticException {
        return Coin.valueOf(Coin.btcToSatoshi(coins));
    }

    public static Coin ofSat(long satoshis) {
        return Coin.valueOf(satoshis);
    }

    public static Coin parseCoin(String str) {
        try {
            long satoshis = Coin.btcToSatoshi(new BigDecimal(str));
            return Coin.valueOf(satoshis);
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Coin parseCoinInexact(String str) {
        try {
            long satoshis = new BigDecimal(str).movePointRight(8).longValue();
            return Coin.valueOf(satoshis);
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Coin add(Coin value) {
        return Coin.valueOf(Math.addExact(this.value, value.value));
    }

    public Coin plus(Coin value) {
        return this.add(value);
    }

    public Coin subtract(Coin value) {
        return Coin.valueOf(Math.subtractExact(this.value, value.value));
    }

    public Coin minus(Coin value) {
        return this.subtract(value);
    }

    public Coin multiply(long factor) {
        return Coin.valueOf(Math.multiplyExact(this.value, factor));
    }

    public Coin times(long factor) {
        return this.multiply(factor);
    }

    public Coin times(int factor) {
        return this.multiply(factor);
    }

    public Coin divide(long divisor) {
        return Coin.valueOf(this.value / divisor);
    }

    public Coin div(long divisor) {
        return this.divide(divisor);
    }

    public Coin div(int divisor) {
        return this.divide(divisor);
    }

    public Coin[] divideAndRemainder(long divisor) {
        return new Coin[]{Coin.valueOf(this.value / divisor), Coin.valueOf(this.value % divisor)};
    }

    public long divide(Coin divisor) {
        return this.value / divisor.value;
    }

    public boolean isPositive() {
        return this.signum() == 1;
    }

    public boolean isNegative() {
        return this.signum() == -1;
    }

    public boolean isZero() {
        return this.signum() == 0;
    }

    public boolean isGreaterThan(Coin other) {
        return this.compareTo(other) > 0;
    }

    public boolean isLessThan(Coin other) {
        return this.compareTo(other) < 0;
    }

    public Coin shiftLeft(int n) {
        return Coin.valueOf(this.value << n);
    }

    public Coin shiftRight(int n) {
        return Coin.valueOf(this.value >> n);
    }

    @Override
    public int signum() {
        if (this.value == 0L) {
            return 0;
        }
        return this.value < 0L ? -1 : 1;
    }

    public Coin negate() {
        return Coin.valueOf(-this.value);
    }

    public long longValue() {
        return this.value;
    }

    public long toSat() {
        return this.value;
    }

    public BigDecimal toBtc() {
        return Coin.satoshiToBtc(this.value);
    }

    public ByteBuffer write(ByteBuffer buf) throws BufferOverflowException {
        return buf.order(ByteOrder.LITTLE_ENDIAN).putLong(this.value);
    }

    public byte[] serialize() {
        ByteBuffer buf = ByteBuffer.allocate(8);
        return this.write(buf).array();
    }

    public String toFriendlyString() {
        return FRIENDLY_FORMAT.format(this).toString();
    }

    public String toPlainString() {
        return PLAIN_FORMAT.format(this).toString();
    }

    public String toString() {
        return Long.toString(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value == ((Coin)o).value;
    }

    public int hashCode() {
        return (int)this.value;
    }

    @Override
    public int compareTo(Coin other) {
        return Long.compare(this.value, other.value);
    }
}

