/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bitcoinj.base.Address;
import org.bitcoinj.base.AddressParser;
import org.bitcoinj.base.Base58;
import org.bitcoinj.base.Bech32;
import org.bitcoinj.base.BitcoinNetwork;
import org.bitcoinj.base.LegacyAddress;
import org.bitcoinj.base.Network;
import org.bitcoinj.base.SegwitAddress;
import org.bitcoinj.base.exceptions.AddressFormatException;
import org.bitcoinj.base.internal.StreamUtils;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.params.Networks;

class DefaultAddressParserProvider
implements AddressParser.AddressParserProvider {
    static final List<Network> DEFAULT_NETWORKS_SEGWIT = DefaultAddressParserProvider.unmodifiableList(BitcoinNetwork.MAINNET, BitcoinNetwork.TESTNET, BitcoinNetwork.REGTEST);
    static final List<Network> DEFAULT_NETWORKS_LEGACY = DefaultAddressParserProvider.unmodifiableList(BitcoinNetwork.MAINNET, BitcoinNetwork.TESTNET);
    private final List<Network> segwitNetworks;
    private final List<Network> base58Networks;

    DefaultAddressParserProvider() {
        this(DEFAULT_NETWORKS_SEGWIT, DEFAULT_NETWORKS_LEGACY);
    }

    DefaultAddressParserProvider(List<Network> segwitNetworks, List<Network> base58Networks) {
        this.segwitNetworks = segwitNetworks;
        this.base58Networks = base58Networks;
    }

    @Override
    public AddressParser forKnownNetworks() {
        return this::parseAddress;
    }

    @Override
    public AddressParser forNetwork(Network network) {
        return address -> this.parseAddress(address, network);
    }

    @Deprecated
    static DefaultAddressParserProvider fromNetworks() {
        List<Network> nets = Networks.get().stream().map(NetworkParameters::network).collect(StreamUtils.toUnmodifiableList());
        return new DefaultAddressParserProvider(nets, nets);
    }

    private Address parseAddress(String addressString) throws AddressFormatException {
        try {
            return this.parseBase58AnyNetwork(addressString);
        }
        catch (AddressFormatException.WrongNetwork x) {
            throw x;
        }
        catch (AddressFormatException x) {
            try {
                return this.parseBech32AnyNetwork(addressString);
            }
            catch (AddressFormatException.WrongNetwork x2) {
                throw x;
            }
            catch (AddressFormatException x2) {
                throw x2;
            }
        }
    }

    private Address parseAddress(String addressString, Network network) throws AddressFormatException {
        try {
            return LegacyAddress.fromBase58(addressString, network);
        }
        catch (AddressFormatException.WrongNetwork x) {
            throw x;
        }
        catch (AddressFormatException x) {
            try {
                return SegwitAddress.fromBech32(addressString, network);
            }
            catch (AddressFormatException.WrongNetwork x2) {
                throw x;
            }
            catch (AddressFormatException x2) {
                throw new AddressFormatException(addressString);
            }
        }
    }

    private SegwitAddress parseBech32AnyNetwork(String bech32) throws AddressFormatException {
        Bech32.Bech32Data bechData = Bech32.decode(bech32);
        String hrp = bechData.hrp;
        Network network = this.segwitNetworks.stream().filter(n -> hrp.equals(n.segwitAddressHrp())).findFirst().orElseThrow(() -> new AddressFormatException.InvalidPrefix("No network found for " + bech32));
        return SegwitAddress.fromBechData(network, bechData);
    }

    private LegacyAddress parseBase58AnyNetwork(String base58) throws AddressFormatException, AddressFormatException.WrongNetwork {
        int version = Base58.decodeChecked(base58)[0] & 0xFF;
        return this.base58Networks.stream().filter(n -> version == n.legacyAddressHeader() || version == n.legacyP2SHHeader()).findFirst().map(n -> LegacyAddress.fromBase58(base58, n)).orElseThrow(() -> new AddressFormatException.InvalidPrefix("No network found for " + base58));
    }

    private static List<Network> unmodifiableList(Network ... ts) {
        return Collections.unmodifiableList(new ArrayList<Network>(Arrays.asList(ts)));
    }
}

