/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.base;

import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bitcoinj.base.Address;
import org.bitcoinj.base.AddressParser;
import org.bitcoinj.base.Base58;
import org.bitcoinj.base.BitcoinNetwork;
import org.bitcoinj.base.Network;
import org.bitcoinj.base.ScriptType;
import org.bitcoinj.base.exceptions.AddressFormatException;
import org.bitcoinj.base.internal.ByteUtils;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.crypto.ECKey;

public class LegacyAddress
implements Address {
    public static final int LENGTH = 20;
    protected final Network network;
    protected final byte[] bytes;
    public final boolean p2sh;
    private static final Comparator<Address> LEGACY_ADDRESS_COMPARATOR = Address.PARTIAL_ADDRESS_COMPARATOR.thenComparingInt(a -> ((LegacyAddress)a).getVersion()).thenComparing(a -> ((LegacyAddress)a).bytes, ByteUtils.arrayUnsignedComparator());

    private LegacyAddress(Network network, boolean p2sh, byte[] hash160) throws AddressFormatException {
        this.network = LegacyAddress.normalizeNetwork(Objects.requireNonNull(network));
        this.bytes = Objects.requireNonNull(hash160);
        if (hash160.length != 20) {
            throw new AddressFormatException.InvalidDataLength("Legacy addresses are 20 byte (160 bit) hashes, but got: " + hash160.length);
        }
        this.p2sh = p2sh;
    }

    private static Network normalizeNetwork(Network network) {
        BitcoinNetwork bitcoinNetwork;
        if (network instanceof BitcoinNetwork && ((bitcoinNetwork = (BitcoinNetwork)network) == BitcoinNetwork.SIGNET || bitcoinNetwork == BitcoinNetwork.REGTEST)) {
            return BitcoinNetwork.TESTNET;
        }
        return network;
    }

    @Deprecated
    public static LegacyAddress fromPubKeyHash(NetworkParameters params, byte[] hash160) throws AddressFormatException {
        return LegacyAddress.fromPubKeyHash(params.network(), hash160);
    }

    public static LegacyAddress fromPubKeyHash(Network network, byte[] hash160) throws AddressFormatException {
        return new LegacyAddress(network, false, hash160);
    }

    @Deprecated
    public static LegacyAddress fromKey(NetworkParameters params, ECKey key) {
        return (LegacyAddress)key.toAddress(ScriptType.P2PKH, params.network());
    }

    @Deprecated
    public static LegacyAddress fromScriptHash(NetworkParameters params, byte[] hash160) throws AddressFormatException {
        return LegacyAddress.fromScriptHash(params.network(), hash160);
    }

    public static LegacyAddress fromScriptHash(Network network, byte[] hash160) throws AddressFormatException {
        return new LegacyAddress(network, true, hash160);
    }

    @Deprecated
    public static LegacyAddress fromBase58(@Nullable NetworkParameters params, String base58) throws AddressFormatException, AddressFormatException.WrongNetwork {
        return (LegacyAddress)AddressParser.getLegacy(params).parseAddress(base58);
    }

    public static LegacyAddress fromBase58(String base58, @Nonnull Network network) throws AddressFormatException, AddressFormatException.WrongNetwork {
        byte[] versionAndDataBytes = Base58.decodeChecked(base58);
        int version = versionAndDataBytes[0] & 0xFF;
        byte[] bytes = Arrays.copyOfRange(versionAndDataBytes, 1, versionAndDataBytes.length);
        if (version == network.legacyAddressHeader()) {
            return new LegacyAddress(network, false, bytes);
        }
        if (version == network.legacyP2SHHeader()) {
            return new LegacyAddress(network, true, bytes);
        }
        throw new AddressFormatException.WrongNetwork(version);
    }

    @Override
    public Network network() {
        return this.network;
    }

    public int getVersion() {
        return this.p2sh ? this.network.legacyP2SHHeader() : this.network.legacyAddressHeader();
    }

    public String toBase58() {
        return Base58.encodeChecked(this.getVersion(), this.bytes);
    }

    @Override
    public byte[] getHash() {
        return this.bytes;
    }

    @Override
    public ScriptType getOutputScriptType() {
        return this.p2sh ? ScriptType.P2SH : ScriptType.P2PKH;
    }

    @Deprecated
    public static NetworkParameters getParametersFromAddress(String address) throws AddressFormatException {
        return NetworkParameters.fromAddress(AddressParser.getLegacy().parseAddress(address));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LegacyAddress other = (LegacyAddress)o;
        return this.network == other.network && Arrays.equals(this.bytes, other.bytes) && this.p2sh == other.p2sh;
    }

    public int hashCode() {
        return Objects.hash(this.network, Arrays.hashCode(this.bytes), this.p2sh);
    }

    public String toString() {
        return this.toBase58();
    }

    @Override
    public int compareTo(Address o) {
        return LEGACY_ADDRESS_COMPARATOR.compare(this, o);
    }

    public static enum P2SHHeader {
        X5(5, BitcoinNetwork.MAINNET, new BitcoinNetwork[0]),
        X196(196, BitcoinNetwork.TESTNET, BitcoinNetwork.SIGNET, BitcoinNetwork.REGTEST);

        private final int headerByte;
        private final EnumSet<BitcoinNetwork> networks;

        public static P2SHHeader ofNetwork(BitcoinNetwork network) {
            return Stream.of(P2SHHeader.values()).filter(header -> header.networks.contains(network)).findFirst().orElseThrow(IllegalStateException::new);
        }

        private P2SHHeader(int headerByte, BitcoinNetwork first, BitcoinNetwork ... rest) {
            this.headerByte = headerByte;
            this.networks = EnumSet.of(first, rest);
        }

        public int headerByte() {
            return this.headerByte;
        }
    }

    public static enum AddressHeader {
        X0(0, BitcoinNetwork.MAINNET, new BitcoinNetwork[0]),
        X111(111, BitcoinNetwork.TESTNET, BitcoinNetwork.REGTEST),
        X6F(111, BitcoinNetwork.SIGNET, new BitcoinNetwork[0]);

        private final int headerByte;
        private final EnumSet<BitcoinNetwork> networks;

        public static AddressHeader ofNetwork(BitcoinNetwork network) {
            return Stream.of(AddressHeader.values()).filter(header -> header.networks.contains(network)).findFirst().orElseThrow(IllegalStateException::new);
        }

        private AddressHeader(int headerByte, BitcoinNetwork first, BitcoinNetwork ... rest) {
            this.headerByte = headerByte;
            this.networks = EnumSet.of(first, rest);
        }

        public int headerByte() {
            return this.headerByte;
        }
    }
}

