/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.base;

import java.util.Arrays;
import java.util.Optional;

public enum ScriptType {
    P2PKH("pkh", 1),
    P2PK("pk", 2),
    P2SH("sh", 3),
    P2WPKH("wpkh", 4),
    P2WSH("wsh", 5),
    P2TR("tr", 6);

    private final String scriptIdentifierString;
    @Deprecated
    public final int id;

    private ScriptType(String id, int numericId) {
        this.scriptIdentifierString = id;
        this.id = numericId;
    }

    public static ScriptType of(String id) {
        return ScriptType.find(id).orElseThrow(() -> new IllegalArgumentException("Unknown ScriptType ID"));
    }

    public static Optional<ScriptType> find(String id) {
        return Arrays.stream(ScriptType.values()).filter(v -> v.id().equals(id)).findFirst();
    }

    public String id() {
        return this.scriptIdentifierString;
    }

    @Deprecated
    public int numericId() {
        return this.id;
    }
}

