/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.base;

import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bitcoinj.base.Address;
import org.bitcoinj.base.AddressParser;
import org.bitcoinj.base.Bech32;
import org.bitcoinj.base.BitcoinNetwork;
import org.bitcoinj.base.Network;
import org.bitcoinj.base.ScriptType;
import org.bitcoinj.base.exceptions.AddressFormatException;
import org.bitcoinj.base.internal.ByteUtils;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.crypto.ECKey;

public class SegwitAddress
implements Address {
    public static final int WITNESS_PROGRAM_LENGTH_PKH = 20;
    public static final int WITNESS_PROGRAM_LENGTH_SH = 32;
    public static final int WITNESS_PROGRAM_LENGTH_TR = 32;
    public static final int WITNESS_PROGRAM_MIN_LENGTH = 2;
    public static final int WITNESS_PROGRAM_MAX_LENGTH = 40;
    protected final Network network;
    protected final short witnessVersion;
    protected final byte[] witnessProgram;
    private static final Comparator<Address> SEGWIT_ADDRESS_COMPARATOR = Address.PARTIAL_ADDRESS_COMPARATOR.thenComparing(a -> ((SegwitAddress)a).witnessVersion).thenComparing(a -> ((SegwitAddress)a).witnessProgram, ByteUtils.arrayUnsignedComparator());

    private static Network normalizeNetwork(Network network) {
        BitcoinNetwork bitcoinNetwork;
        if (network instanceof BitcoinNetwork && (bitcoinNetwork = (BitcoinNetwork)network) == BitcoinNetwork.SIGNET) {
            return BitcoinNetwork.TESTNET;
        }
        return network;
    }

    private SegwitAddress(Network network, int witnessVersion, byte[] witnessProgram) throws AddressFormatException {
        if (witnessVersion < 0 || witnessVersion > 16) {
            throw new AddressFormatException("Invalid script version: " + witnessVersion);
        }
        if (witnessProgram.length < 2 || witnessProgram.length > 40) {
            throw new AddressFormatException.InvalidDataLength("Invalid length: " + witnessProgram.length);
        }
        if (witnessVersion == 0 && witnessProgram.length != 20 && witnessProgram.length != 32) {
            throw new AddressFormatException.InvalidDataLength("Invalid length for address version 0: " + witnessProgram.length);
        }
        if (witnessVersion == 1 && witnessProgram.length != 32) {
            throw new AddressFormatException.InvalidDataLength("Invalid length for address version 1: " + witnessProgram.length);
        }
        this.network = SegwitAddress.normalizeNetwork(Objects.requireNonNull(network));
        this.witnessVersion = (short)witnessVersion;
        this.witnessProgram = Objects.requireNonNull(witnessProgram);
    }

    public int getWitnessVersion() {
        return this.witnessVersion;
    }

    public byte[] getWitnessProgram() {
        return this.witnessProgram;
    }

    @Override
    public byte[] getHash() {
        return this.getWitnessProgram();
    }

    @Override
    public ScriptType getOutputScriptType() {
        int version = this.getWitnessVersion();
        if (version == 0) {
            int programLength = this.getWitnessProgram().length;
            if (programLength == 20) {
                return ScriptType.P2WPKH;
            }
            if (programLength == 32) {
                return ScriptType.P2WSH;
            }
            throw new IllegalStateException();
        }
        if (version == 1) {
            int programLength = this.getWitnessProgram().length;
            if (programLength == 32) {
                return ScriptType.P2TR;
            }
            throw new IllegalStateException();
        }
        throw new IllegalStateException("cannot handle: " + version);
    }

    public String toString() {
        return this.toBech32();
    }

    @Deprecated
    public static SegwitAddress fromBech32(@Nullable NetworkParameters params, String bech32) throws AddressFormatException {
        return (SegwitAddress)AddressParser.getLegacy(params).parseAddress(bech32);
    }

    public static SegwitAddress fromBech32(String bech32, @Nonnull Network network) throws AddressFormatException {
        Bech32.Bech32Data bechData = Bech32.decode(bech32);
        if (bechData.hrp.equals(network.segwitAddressHrp())) {
            return SegwitAddress.fromBechData(network, bechData);
        }
        throw new AddressFormatException.WrongNetwork(bechData.hrp);
    }

    static SegwitAddress fromBechData(@Nonnull Network network, Bech32.Bech32Data bechData) {
        if (bechData.bytes().length < 1) {
            throw new AddressFormatException.InvalidDataLength("invalid address length (0)");
        }
        short witnessVersion = bechData.witnessVersion();
        SegwitAddress address = new SegwitAddress(network, witnessVersion, bechData.witnessProgram());
        if (witnessVersion == 0 && bechData.encoding != Bech32.Encoding.BECH32 || witnessVersion != 0 && bechData.encoding != Bech32.Encoding.BECH32M) {
            throw new AddressFormatException.UnexpectedWitnessVersion("Unexpected witness version: " + witnessVersion);
        }
        return address;
    }

    @Deprecated
    public static SegwitAddress fromHash(NetworkParameters params, byte[] hash) {
        return SegwitAddress.fromHash(params.network(), hash);
    }

    public static SegwitAddress fromHash(Network network, byte[] hash) {
        return new SegwitAddress(network, 0, hash);
    }

    @Deprecated
    public static SegwitAddress fromProgram(NetworkParameters params, int witnessVersion, byte[] witnessProgram) {
        return SegwitAddress.fromProgram(params.network(), witnessVersion, witnessProgram);
    }

    public static SegwitAddress fromProgram(Network network, int witnessVersion, byte[] witnessProgram) {
        return new SegwitAddress(network, witnessVersion, witnessProgram);
    }

    @Deprecated
    public static SegwitAddress fromKey(NetworkParameters params, ECKey key) {
        return (SegwitAddress)key.toAddress(ScriptType.P2WPKH, params.network());
    }

    @Override
    public Network network() {
        return this.network;
    }

    public int hashCode() {
        return Objects.hash(this.network, this.witnessVersion, Arrays.hashCode(this.witnessProgram));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegwitAddress other = (SegwitAddress)o;
        return this.network == other.network && this.witnessVersion == other.witnessVersion && Arrays.equals(this.witnessProgram, other.witnessProgram);
    }

    public String toBech32() {
        Bech32.Encoding encoding = this.witnessVersion == 0 ? Bech32.Encoding.BECH32 : Bech32.Encoding.BECH32M;
        return Bech32.encode(encoding, this.network.segwitAddressHrp(), Bech32.Bech32Bytes.ofSegwit(this.witnessVersion, this.witnessProgram));
    }

    @Override
    public int compareTo(Address o) {
        return SEGWIT_ADDRESS_COMPARATOR.compare(this, o);
    }

    public static enum SegwitHrp {
        BC(BitcoinNetwork.MAINNET),
        TB(BitcoinNetwork.TESTNET, BitcoinNetwork.SIGNET),
        BCRT(BitcoinNetwork.REGTEST);

        private final EnumSet<BitcoinNetwork> networks;

        private SegwitHrp(BitcoinNetwork n2) {
            this.networks = EnumSet.of(n2);
        }

        private SegwitHrp(BitcoinNetwork n1, BitcoinNetwork n2) {
            this.networks = EnumSet.of(n1, n2);
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        public static SegwitHrp of(String hrp) {
            return SegwitHrp.valueOf(hrp.toUpperCase());
        }

        public static Optional<SegwitHrp> find(String hrp) {
            try {
                return Optional.of(SegwitHrp.of(hrp));
            }
            catch (IllegalArgumentException iae) {
                return Optional.empty();
            }
        }

        public static SegwitHrp ofNetwork(BitcoinNetwork network) {
            return Stream.of(SegwitHrp.values()).filter(hrp -> hrp.networks.contains(network)).findFirst().orElseThrow(IllegalStateException::new);
        }
    }
}

