/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.base;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.bitcoinj.base.internal.ByteUtils;
import org.bitcoinj.base.internal.Preconditions;

public class Sha256Hash
implements Comparable<Sha256Hash> {
    public static final int LENGTH = 32;
    public static final Sha256Hash ZERO_HASH = Sha256Hash.wrap(new byte[32]);
    private final byte[] bytes;

    private Sha256Hash(byte[] rawHashBytes) {
        Preconditions.checkArgument(rawHashBytes.length == 32, () -> "length must be 32: " + rawHashBytes.length);
        this.bytes = rawHashBytes;
    }

    public static Sha256Hash wrap(byte[] rawHashBytes) {
        return new Sha256Hash(rawHashBytes);
    }

    public static Sha256Hash wrap(String hexString) {
        return Sha256Hash.wrap(ByteUtils.parseHex(hexString));
    }

    public static Sha256Hash wrapReversed(byte[] rawHashBytes) {
        return Sha256Hash.wrap(ByteUtils.reverseBytes(rawHashBytes));
    }

    public static Sha256Hash read(ByteBuffer buf) throws BufferUnderflowException {
        byte[] b = new byte[32];
        buf.get(b);
        return Sha256Hash.wrapReversed(b);
    }

    public static Sha256Hash of(byte[] contents) {
        return Sha256Hash.wrap(Sha256Hash.hash(contents));
    }

    public static Sha256Hash twiceOf(byte[] contents) {
        return Sha256Hash.wrap(Sha256Hash.hashTwice(contents));
    }

    public static Sha256Hash twiceOf(byte[] content1, byte[] content2) {
        return Sha256Hash.wrap(Sha256Hash.hashTwice(content1, content2));
    }

    public static Sha256Hash of(File file) throws IOException {
        return Sha256Hash.of(Files.readAllBytes(file.toPath()));
    }

    public static MessageDigest newDigest() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] hash(byte[] input) {
        return Sha256Hash.hash(input, 0, input.length);
    }

    public static byte[] hash(byte[] input, int offset, int length) {
        MessageDigest digest = Sha256Hash.newDigest();
        digest.update(input, offset, length);
        return digest.digest();
    }

    public static byte[] hashTwice(byte[] input) {
        return Sha256Hash.hashTwice(input, 0, input.length);
    }

    public static byte[] hashTwice(byte[] input1, byte[] input2) {
        MessageDigest digest = Sha256Hash.newDigest();
        digest.update(input1);
        digest.update(input2);
        return digest.digest(digest.digest());
    }

    public static byte[] hashTwice(byte[] input, int offset, int length) {
        MessageDigest digest = Sha256Hash.newDigest();
        digest.update(input, offset, length);
        return digest.digest(digest.digest());
    }

    public static byte[] hashTwice(byte[] input1, int offset1, int length1, byte[] input2, int offset2, int length2) {
        MessageDigest digest = Sha256Hash.newDigest();
        digest.update(input1, offset1, length1);
        digest.update(input2, offset2, length2);
        return digest.digest(digest.digest());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Arrays.equals(this.bytes, ((Sha256Hash)o).bytes);
    }

    public int hashCode() {
        return ByteBuffer.wrap(this.bytes).getInt(28);
    }

    public String toString() {
        return ByteUtils.formatHex(this.bytes);
    }

    public BigInteger toBigInteger() {
        return ByteUtils.bytesToBigInteger(this.bytes);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public byte[] serialize() {
        return ByteUtils.reverseBytes(this.bytes);
    }

    @Deprecated
    public byte[] getReversedBytes() {
        return this.serialize();
    }

    public ByteBuffer write(ByteBuffer buf) throws BufferOverflowException {
        buf.put(this.serialize());
        return buf;
    }

    @Override
    public int compareTo(Sha256Hash other) {
        for (int i2 = 31; i2 >= 0; --i2) {
            int thisByte = this.bytes[i2] & 0xFF;
            int otherByte = other.bytes[i2] & 0xFF;
            if (thisByte > otherByte) {
                return 1;
            }
            if (thisByte >= otherByte) continue;
            return -1;
        }
        return 0;
    }
}

