/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.base;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import org.bitcoinj.base.internal.Preconditions;

public class VarInt {
    private final long value;
    private final int originallyEncodedSize;
    private static final int SIZE_BYTE = 1;
    private static final int SIZE_SHORT = 3;
    private static final int SIZE_INT = 5;
    private static final int SIZE_LONG = 9;

    public static VarInt of(long value) {
        return new VarInt(value, VarInt.sizeOf(value));
    }

    public static VarInt ofBytes(byte[] buf, int offset) throws ArrayIndexOutOfBoundsException {
        Preconditions.check(offset >= 0 && offset < buf.length, () -> new ArrayIndexOutOfBoundsException(offset));
        return VarInt.read(ByteBuffer.wrap(buf, offset, buf.length - offset));
    }

    public static VarInt read(ByteBuffer buf) throws BufferUnderflowException {
        int originallyEncodedSize;
        long value;
        buf.order(ByteOrder.LITTLE_ENDIAN);
        int first = Byte.toUnsignedInt(buf.get());
        if (first < 253) {
            value = first;
            originallyEncodedSize = 1;
        } else if (first == 253) {
            value = Short.toUnsignedInt(buf.getShort());
            originallyEncodedSize = 3;
        } else if (first == 254) {
            value = Integer.toUnsignedLong(buf.getInt());
            originallyEncodedSize = 5;
        } else {
            value = buf.getLong();
            originallyEncodedSize = 9;
        }
        return new VarInt(value, originallyEncodedSize);
    }

    private VarInt(long value, int originallyEncodedSize) {
        this.value = value;
        this.originallyEncodedSize = originallyEncodedSize;
    }

    @Deprecated
    public VarInt(long value) {
        this.value = value;
        this.originallyEncodedSize = this.getSizeInBytes();
    }

    @Deprecated
    public VarInt(byte[] buf, int offset) {
        VarInt copy = VarInt.read(ByteBuffer.wrap(buf, offset, buf.length));
        this.value = copy.value;
        this.originallyEncodedSize = copy.originallyEncodedSize;
    }

    public long longValue() {
        return this.value;
    }

    public boolean fitsInt() {
        return this.value >= 0L && this.value <= Integer.MAX_VALUE;
    }

    public int intValue() throws ArithmeticException {
        Preconditions.check(this.fitsInt(), () -> new ArithmeticException("value too large for an int: " + Long.toUnsignedString(this.value)));
        return (int)this.value;
    }

    public int getOriginalSizeInBytes() {
        return this.originallyEncodedSize;
    }

    public final int getSizeInBytes() {
        return VarInt.sizeOf(this.value);
    }

    public static int sizeOf(long value) {
        if (value < 0L) {
            return 9;
        }
        if (value < 253L) {
            return 1;
        }
        if (value <= 65535L) {
            return 3;
        }
        if (value <= 0xFFFFFFFFL) {
            return 5;
        }
        return 9;
    }

    public byte[] serialize() {
        ByteBuffer buf = ByteBuffer.allocate(VarInt.sizeOf(this.value));
        return this.write(buf).array();
    }

    public ByteBuffer write(ByteBuffer buf) throws BufferOverflowException {
        buf.order(ByteOrder.LITTLE_ENDIAN);
        switch (VarInt.sizeOf(this.value)) {
            case 1: {
                buf.put((byte)this.value);
                break;
            }
            case 3: {
                buf.put((byte)-3);
                buf.putShort((short)this.value);
                break;
            }
            case 5: {
                buf.put((byte)-2);
                buf.putInt((int)this.value);
                break;
            }
            default: {
                buf.put((byte)-1);
                buf.putLong(this.value);
            }
        }
        return buf;
    }

    public String toString() {
        return Long.toUnsignedString(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value == ((VarInt)o).value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

