/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.base.internal;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.bitcoinj.base.VarInt;
import org.bitcoinj.base.internal.Preconditions;

public class Buffers {
    public static byte[] readBytes(ByteBuffer buf, int length) throws BufferUnderflowException {
        Preconditions.check(length <= buf.remaining(), BufferUnderflowException::new);
        byte[] b = new byte[length];
        buf.get(b);
        return b;
    }

    public static byte[] readLengthPrefixedBytes(ByteBuffer buf) throws BufferUnderflowException {
        VarInt length = VarInt.read(buf);
        Preconditions.check(length.fitsInt(), BufferUnderflowException::new);
        return Buffers.readBytes(buf, length.intValue());
    }

    public static ByteBuffer writeLengthPrefixedBytes(ByteBuffer buf, byte[] bytes) throws BufferOverflowException {
        return buf.put(VarInt.of(bytes.length).serialize()).put(bytes);
    }

    public static String readLengthPrefixedString(ByteBuffer buf) throws BufferUnderflowException {
        return new String(Buffers.readLengthPrefixedBytes(buf), StandardCharsets.UTF_8);
    }

    public static ByteBuffer writeLengthPrefixedString(ByteBuffer buf, String str) throws BufferOverflowException {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        return Buffers.writeLengthPrefixedBytes(buf, bytes);
    }

    public static ByteBuffer skipBytes(ByteBuffer buf, int numBytes) throws BufferUnderflowException {
        Preconditions.checkArgument(numBytes >= 0);
        Preconditions.check(numBytes <= buf.remaining(), BufferUnderflowException::new);
        buf.position(buf.position() + numBytes);
        return buf;
    }
}

