/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.base.internal;

import java.util.Arrays;
import org.bitcoinj.base.internal.ByteUtils;

public class ByteArray
implements Comparable<ByteArray> {
    protected final byte[] bytes;

    public ByteArray(byte[] bytes) {
        this.bytes = new byte[bytes.length];
        System.arraycopy(bytes, 0, this.bytes, 0, bytes.length);
    }

    public byte[] bytes() {
        byte[] copy = new byte[this.bytes.length];
        System.arraycopy(this.bytes, 0, copy, 0, this.bytes.length);
        return copy;
    }

    public String formatHex() {
        return ByteUtils.formatHex(this.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteArray other = (ByteArray)o;
        return Arrays.equals(this.bytes, other.bytes);
    }

    @Override
    public int compareTo(ByteArray o) {
        return ByteUtils.arrayUnsignedComparator().compare(this.bytes, o.bytes);
    }
}

