/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.base.internal;

import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Comparator;
import org.bitcoinj.base.internal.HexFormat;
import org.bitcoinj.base.internal.Preconditions;

public class ByteUtils {
    public static final int MAX_UNSIGNED_SHORT = Short.toUnsignedInt((short)-1);
    public static final long MAX_UNSIGNED_INTEGER = Integer.toUnsignedLong(-1);
    @Deprecated
    public static final BaseEncoding HEX = BaseEncoding.base16().lowerCase();
    private static final int[] bitMask = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
    private static final HexFormat hexFormat = new HexFormat();
    private static final Comparator<byte[]> ARRAY_UNSIGNED_COMPARATOR = (a, b) -> {
        int minLength = Math.min(((byte[])a).length, ((byte[])b).length);
        for (int i2 = 0; i2 < minLength; ++i2) {
            int result = ByteUtils.compareUnsigned(a[i2], b[i2]);
            if (result == 0) continue;
            return result;
        }
        return ((byte[])a).length - ((byte[])b).length;
    };

    public static String formatHex(byte[] bytes) {
        return hexFormat.formatHex(bytes);
    }

    public static byte[] parseHex(String string) {
        return hexFormat.parseHex(string);
    }

    public static byte[] bigIntegerToBytes(BigInteger b, int numBytes) {
        Preconditions.checkArgument(b.signum() >= 0, () -> "b must be positive or zero: " + b);
        Preconditions.checkArgument(numBytes > 0, () -> "numBytes must be positive: " + numBytes);
        byte[] src = b.toByteArray();
        byte[] dest = new byte[numBytes];
        boolean isFirstByteOnlyForSign = src[0] == 0;
        int length = isFirstByteOnlyForSign ? src.length - 1 : src.length;
        Preconditions.checkArgument(length <= numBytes, () -> "The given number does not fit in " + numBytes);
        int srcPos = isFirstByteOnlyForSign ? 1 : 0;
        int destPos = numBytes - length;
        System.arraycopy(src, srcPos, dest, destPos, length);
        return dest;
    }

    public static BigInteger bytesToBigInteger(byte[] bytes) {
        return new BigInteger(1, bytes);
    }

    public static ByteBuffer writeInt16LE(int val, ByteBuffer buf) throws BufferOverflowException {
        Preconditions.checkArgument(val >= 0 && val <= MAX_UNSIGNED_SHORT, () -> "value out of range: " + val);
        return buf.order(ByteOrder.LITTLE_ENDIAN).putShort((short)val);
    }

    public static ByteBuffer writeInt16BE(int val, ByteBuffer buf) throws BufferOverflowException {
        Preconditions.checkArgument(val >= 0 && val <= MAX_UNSIGNED_SHORT, () -> "value out of range: " + val);
        return buf.order(ByteOrder.BIG_ENDIAN).putShort((short)val);
    }

    public static ByteBuffer writeInt32LE(int val, ByteBuffer buf) throws BufferOverflowException {
        return buf.order(ByteOrder.LITTLE_ENDIAN).putInt(val);
    }

    public static ByteBuffer writeInt32LE(long val, ByteBuffer buf) throws BufferOverflowException {
        Preconditions.checkArgument(val >= 0L && val <= MAX_UNSIGNED_INTEGER, () -> "value out of range: " + val);
        return buf.order(ByteOrder.LITTLE_ENDIAN).putInt((int)val);
    }

    public static void writeInt32LE(long val, byte[] out, int offset) throws ArrayIndexOutOfBoundsException {
        Preconditions.check(offset >= 0 && offset <= out.length - 4, () -> new ArrayIndexOutOfBoundsException(offset));
        ByteUtils.writeInt32LE(val, ByteBuffer.wrap(out, offset, out.length - offset));
    }

    public static ByteBuffer writeInt32BE(int val, ByteBuffer buf) throws BufferOverflowException {
        return buf.order(ByteOrder.BIG_ENDIAN).putInt(val);
    }

    public static void writeInt32BE(int val, byte[] out, int offset) throws ArrayIndexOutOfBoundsException {
        ByteUtils.writeInt32BE(val, ByteBuffer.wrap(out, offset, out.length - offset));
    }

    public static ByteBuffer writeInt64LE(long val, ByteBuffer buf) throws BufferOverflowException {
        return buf.order(ByteOrder.LITTLE_ENDIAN).putLong(val);
    }

    public static void writeInt64LE(long val, byte[] out, int offset) throws ArrayIndexOutOfBoundsException {
        Preconditions.check(offset >= 0 && offset <= out.length + 8, () -> new ArrayIndexOutOfBoundsException(offset));
        ByteUtils.writeInt64LE(val, ByteBuffer.wrap(out, offset, out.length - offset));
    }

    public static void writeInt16LE(int val, OutputStream stream) throws IOException {
        byte[] buf = new byte[2];
        ByteUtils.writeInt16LE(val, ByteBuffer.wrap(buf));
        stream.write(buf);
    }

    public static void writeInt16BE(int val, OutputStream stream) throws IOException {
        byte[] buf = new byte[2];
        ByteUtils.writeInt16BE(val, ByteBuffer.wrap(buf));
        stream.write(buf);
    }

    public static void writeInt32LE(int val, OutputStream stream) throws IOException {
        byte[] buf = new byte[4];
        ByteUtils.writeInt32LE(val, ByteBuffer.wrap(buf));
        stream.write(buf);
    }

    public static void writeInt32LE(long val, OutputStream stream) throws IOException {
        byte[] buf = new byte[4];
        ByteUtils.writeInt32LE(val, ByteBuffer.wrap(buf));
        stream.write(buf);
    }

    public static void writeInt32BE(int val, OutputStream stream) throws IOException {
        byte[] buf = new byte[4];
        ByteUtils.writeInt32BE(val, ByteBuffer.wrap(buf));
        stream.write(buf);
    }

    public static void writeInt64LE(long val, OutputStream stream) throws IOException {
        byte[] buf = new byte[8];
        ByteUtils.writeInt64LE(val, ByteBuffer.wrap(buf));
        stream.write(buf);
    }

    public static void writeInt64LE(BigInteger val, OutputStream stream) throws IOException {
        byte[] bytes = val.toByteArray();
        if (bytes.length > 8) {
            throw new RuntimeException("Input too large to encode into a uint64");
        }
        bytes = ByteUtils.reverseBytes(bytes);
        stream.write(bytes);
        if (bytes.length < 8) {
            for (int i2 = 0; i2 < 8 - bytes.length; ++i2) {
                stream.write(0);
            }
        }
    }

    public static int readUint16(ByteBuffer buf) throws BufferUnderflowException {
        return Short.toUnsignedInt(buf.order(ByteOrder.LITTLE_ENDIAN).getShort());
    }

    public static int readUint16(byte[] bytes, int offset) throws ArrayIndexOutOfBoundsException {
        Preconditions.check(offset >= 0 && offset <= bytes.length - 2, () -> new ArrayIndexOutOfBoundsException(offset));
        return ByteUtils.readUint16(ByteBuffer.wrap(bytes, offset, bytes.length - offset));
    }

    public static int readUint16BE(ByteBuffer buf) throws BufferUnderflowException {
        return Short.toUnsignedInt(buf.order(ByteOrder.BIG_ENDIAN).getShort());
    }

    public static int readUint16BE(byte[] bytes, int offset) throws ArrayIndexOutOfBoundsException {
        Preconditions.check(offset >= 0 && offset <= bytes.length - 2, () -> new ArrayIndexOutOfBoundsException(offset));
        return ByteUtils.readUint16BE(ByteBuffer.wrap(bytes, offset, bytes.length - offset));
    }

    public static long readUint32(ByteBuffer buf) throws BufferUnderflowException {
        return Integer.toUnsignedLong(buf.order(ByteOrder.LITTLE_ENDIAN).getInt());
    }

    public static int readInt32(ByteBuffer buf) throws BufferUnderflowException {
        return buf.order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    public static long readUint32(byte[] bytes, int offset) throws ArrayIndexOutOfBoundsException {
        Preconditions.check(offset >= 0 && offset <= bytes.length - 4, () -> new ArrayIndexOutOfBoundsException(offset));
        return ByteUtils.readUint32(ByteBuffer.wrap(bytes, offset, bytes.length - offset));
    }

    public static long readUint32BE(ByteBuffer buf) throws BufferUnderflowException {
        return Integer.toUnsignedLong(buf.order(ByteOrder.BIG_ENDIAN).getInt());
    }

    public static long readUint32BE(byte[] bytes, int offset) throws ArrayIndexOutOfBoundsException {
        Preconditions.check(offset >= 0 && offset <= bytes.length - 4, () -> new ArrayIndexOutOfBoundsException(offset));
        return ByteUtils.readUint32BE(ByteBuffer.wrap(bytes, offset, bytes.length - offset));
    }

    public static long readInt64(ByteBuffer buf) throws BufferUnderflowException {
        return buf.order(ByteOrder.LITTLE_ENDIAN).getLong();
    }

    public static long readInt64(byte[] bytes, int offset) throws ArrayIndexOutOfBoundsException {
        Preconditions.check(offset >= 0 && offset <= bytes.length - 8, () -> new ArrayIndexOutOfBoundsException(offset));
        return ByteUtils.readInt64(ByteBuffer.wrap(bytes, offset, bytes.length - offset));
    }

    public static int readUint16(InputStream is) {
        byte[] buf = new byte[2];
        try {
            is.read(buf);
            return ByteUtils.readUint16(ByteBuffer.wrap(buf));
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public static long readUint32(InputStream is) {
        byte[] buf = new byte[4];
        try {
            is.read(buf);
            return ByteUtils.readUint32(ByteBuffer.wrap(buf));
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public static byte[] reverseBytes(byte[] bytes) {
        byte[] buf = new byte[bytes.length];
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            buf[i2] = bytes[bytes.length - 1 - i2];
        }
        return buf;
    }

    public static BigInteger decodeMPI(byte[] mpi, boolean hasLength) {
        boolean isNegative;
        byte[] buf;
        if (hasLength) {
            int length = (int)ByteUtils.readUint32BE(mpi, 0);
            buf = new byte[length];
            System.arraycopy(mpi, 4, buf, 0, length);
        } else {
            buf = mpi;
        }
        if (buf.length == 0) {
            return BigInteger.ZERO;
        }
        boolean bl = isNegative = (buf[0] & 0x80) == 128;
        if (isNegative) {
            buf[0] = (byte)(buf[0] & 0x7F);
        }
        BigInteger result = new BigInteger(buf);
        return isNegative ? result.negate() : result;
    }

    public static byte[] encodeMPI(BigInteger value, boolean includeLength) {
        byte[] result;
        boolean isNegative;
        if (value.equals(BigInteger.ZERO)) {
            if (!includeLength) {
                return new byte[0];
            }
            return new byte[]{0, 0, 0, 0};
        }
        boolean bl = isNegative = value.signum() < 0;
        if (isNegative) {
            value = value.negate();
        }
        byte[] array = value.toByteArray();
        int length = array.length;
        if ((array[0] & 0x80) == 128) {
            ++length;
        }
        if (includeLength) {
            byte[] result2 = new byte[length + 4];
            System.arraycopy(array, 0, result2, length - array.length + 3, array.length);
            ByteUtils.writeInt32BE(length, result2, 0);
            if (isNegative) {
                result2[4] = (byte)(result2[4] | 0x80);
            }
            return result2;
        }
        if (length != array.length) {
            result = new byte[length];
            System.arraycopy(array, 0, result, 1, array.length);
        } else {
            result = array;
        }
        if (isNegative) {
            result[0] = (byte)(result[0] | 0x80);
        }
        return result;
    }

    public static BigInteger decodeCompactBits(long compact) {
        int size = (int)(compact >> 24) & 0xFF;
        byte[] bytes = new byte[4 + size];
        bytes[3] = (byte)size;
        if (size >= 1) {
            bytes[4] = (byte)(compact >> 16 & 0xFFL);
        }
        if (size >= 2) {
            bytes[5] = (byte)(compact >> 8 & 0xFFL);
        }
        if (size >= 3) {
            bytes[6] = (byte)(compact & 0xFFL);
        }
        return ByteUtils.decodeMPI(bytes, true);
    }

    public static long encodeCompactBits(BigInteger value) {
        int size = value.toByteArray().length;
        long result = size <= 3 ? value.longValue() << 8 * (3 - size) : value.shiftRight(8 * (size - 3)).longValue();
        if ((result & 0x800000L) != 0L) {
            result >>= 8;
            ++size;
        }
        result |= (long)size << 24;
        return result |= value.signum() == -1 ? 0x800000L : 0L;
    }

    public static boolean checkBitLE(byte[] data, int index) {
        return (data[index >>> 3] & bitMask[7 & index]) != 0;
    }

    public static void setBitLE(byte[] data, int index) {
        int n = index >>> 3;
        data[n] = (byte)(data[n] | bitMask[7 & index]);
    }

    public static Comparator<byte[]> arrayUnsignedComparator() {
        return ARRAY_UNSIGNED_COMPARATOR;
    }

    private static int compareUnsigned(byte a, byte b) {
        return Byte.toUnsignedInt(a) - Byte.toUnsignedInt(b);
    }

    public static byte[] concat(byte[] b1, byte[] b2) {
        byte[] result = new byte[b1.length + b2.length];
        System.arraycopy(b1, 0, result, 0, b1.length);
        System.arraycopy(b2, 0, result, b1.length, b2.length);
        return result;
    }
}

