/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.base.internal;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class FutureUtils {
    public static <T> CompletableFuture<List<T>> allAsList(List<? extends CompletionStage<? extends T>> stages) {
        return FutureUtils.allAsCFList(stages);
    }

    public static <T> CompletableFuture<List<T>> successfulAsList(List<? extends CompletionStage<? extends T>> stages) {
        return FutureUtils.successfulAsCFList(stages);
    }

    public static <T> CompletableFuture<T> failedFuture(Throwable t) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(t);
        return future;
    }

    private static <T> CompletableFuture<List<T>> allAsCFList(List<? extends CompletionStage<? extends T>> stages) {
        CompletableFuture<T>[] all = FutureUtils.listToArray(stages);
        CompletableFuture<Void> allOf = CompletableFuture.allOf(all);
        stages.forEach(stage -> stage.whenComplete((r, throwable) -> {
            if (throwable != null) {
                allOf.completeExceptionally((Throwable)throwable);
            }
        }));
        return FutureUtils.transformToListResult(allOf, all);
    }

    private static <T> CompletableFuture<List<T>> successfulAsCFList(List<? extends CompletionStage<? extends T>> stages) {
        CompletableFuture<T>[] all = FutureUtils.listToArray2(stages);
        CompletableFuture<Void> allOf = CompletableFuture.allOf(all);
        return FutureUtils.transformToListResult(allOf, all);
    }

    private static <T> CompletableFuture<? extends T>[] listToArray(List<? extends CompletionStage<? extends T>> stages) {
        CompletableFuture[] all = (CompletableFuture[])stages.stream().map(CompletionStage::toCompletableFuture).toArray(FutureUtils.genericArray(CompletableFuture[]::new));
        return all;
    }

    private static <T> CompletableFuture<? extends T>[] listToArray2(List<? extends CompletionStage<? extends T>> stages) {
        CompletableFuture[] all = (CompletableFuture[])stages.stream().map(s -> s.exceptionally(throwable -> null).toCompletableFuture()).toArray(FutureUtils.genericArray(CompletableFuture[]::new));
        return all;
    }

    private static <T> CompletableFuture<List<T>> transformToListResult(CompletableFuture<Void> allOf, CompletableFuture<? extends T>[] all) {
        return allOf.thenApply(ignored -> Arrays.stream(all).map(CompletableFuture::join).collect(Collectors.toList()));
    }

    static <T, R extends T> IntFunction<R[]> genericArray(IntFunction<T[]> arrayCreator) {
        return size -> (Object[])arrayCreator.apply(size);
    }

    @FunctionalInterface
    public static interface ThrowingSupplier<T>
    extends Supplier<T> {
        @Override
        default public T get() {
            try {
                return this.getThrows();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public T getThrows() throws Exception;
    }
}

