/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.base.internal;

public class HexFormat {
    public String formatHex(byte[] bytes) {
        StringBuilder stringBuilder = new StringBuilder(bytes.length * 2);
        for (byte aByte : bytes) {
            stringBuilder.append(this.byteToHex(aByte));
        }
        return stringBuilder.toString();
    }

    public byte[] parseHex(String hexString) {
        if (hexString.length() % 2 == 1) {
            throw new IllegalArgumentException("Invalid hexadecimal String supplied.");
        }
        byte[] bytes = new byte[hexString.length() / 2];
        for (int i2 = 0; i2 < hexString.length(); i2 += 2) {
            bytes[i2 / 2] = this.hexToByte(hexString.substring(i2, i2 + 2));
        }
        return bytes;
    }

    private String byteToHex(byte num) {
        char[] hexDigits = new char[]{Character.forDigit(num >> 4 & 0xF, 16), Character.forDigit(num & 0xF, 16)};
        return new String(hexDigits);
    }

    private byte hexToByte(String hexString) {
        int firstDigit = this.toDigit(hexString.charAt(0));
        int secondDigit = this.toDigit(hexString.charAt(1));
        return (byte)((firstDigit << 4) + secondDigit);
    }

    private int toDigit(char hexChar) {
        int digit = Character.digit(hexChar, 16);
        if (digit == -1) {
            throw new IllegalArgumentException("Invalid Hexadecimal Character: " + hexChar);
        }
        return digit;
    }
}

