/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.base.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

public class InternalUtils {
    public static final Joiner SPACE_JOINER = InternalUtils.joiner(" ");
    public static final Splitter WHITESPACE_SPLITTER = InternalUtils.splitter("\\s+");

    public static Joiner joiner(String delimiter) {
        return list -> list.stream().map(Object::toString).collect(Collectors.joining(delimiter));
    }

    public static Splitter splitter(String regex) {
        return s -> Arrays.asList(s.split(regex));
    }

    public static String commaJoin(String ... strings) {
        return Arrays.stream(strings).filter(Objects::nonNull).collect(Collectors.joining(", "));
    }

    public static <V> V getUninterruptibly(Future<V> future) throws ExecutionException {
        boolean interrupted = false;
        while (true) {
            try {
                V v = future.get();
                return v;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @FunctionalInterface
    public static interface Joiner {
        public String join(List<?> var1);
    }

    @FunctionalInterface
    public static interface Splitter {
        public List<String> splitToList(String var1);
    }
}

