/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.base.internal;

import java.util.function.Supplier;

public class Preconditions {
    public static void checkArgument(boolean expression) {
        Preconditions.check(expression, IllegalArgumentException::new);
    }

    public static void checkArgument(boolean expression, Supplier<String> messageSupplier) {
        Preconditions.check(expression, () -> new IllegalArgumentException((String)messageSupplier.get()));
    }

    public static void checkState(boolean expression) {
        Preconditions.check(expression, IllegalStateException::new);
    }

    public static void checkState(boolean expression, Supplier<String> messageSupplier) {
        Preconditions.check(expression, () -> new IllegalStateException((String)messageSupplier.get()));
    }

    public static <X extends Throwable> void check(boolean expression, Supplier<? extends X> exceptionSupplier) throws X {
        if (!expression) {
            throw (Throwable)exceptionSupplier.get();
        }
    }
}

