/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.base.internal;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.List;
import org.bitcoinj.base.internal.Preconditions;

public class Stopwatch
implements TemporalAmount {
    private final Instant startTime = Instant.now();
    private Instant stopTime = null;

    public static Stopwatch start() {
        return new Stopwatch();
    }

    private Stopwatch() {
    }

    public Stopwatch stop() {
        if (this.isRunning()) {
            this.stopTime = Instant.now();
        }
        return this;
    }

    public boolean isRunning() {
        return this.stopTime == null;
    }

    public Duration elapsed() {
        return Duration.between(this.startTime, this.isRunning() ? Instant.now() : this.stopTime);
    }

    @Override
    public long get(TemporalUnit temporalUnit) {
        Preconditions.checkArgument(temporalUnit.equals(ChronoUnit.MILLIS), () -> "unsupported temporal unit: " + temporalUnit);
        return this.elapsed().toMillis();
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return Arrays.asList(ChronoUnit.MILLIS);
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        return temporal.plus(this.elapsed());
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        return temporal.minus(this.elapsed());
    }

    public String toString() {
        return this.elapsed().toMillis() + " ms";
    }
}

