/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.base.internal;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.TimeZone;

public class TimeUtils {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static volatile Clock clock = Clock.systemUTC();

    public static void setMockClock() {
        TimeUtils.setMockClock(Instant.now());
    }

    public static void setMockClock(Instant fixedInstant) {
        clock = Clock.fixed(fixedInstant, UTC.toZoneId());
    }

    public static void rollMockClock(Duration delta) {
        if (clock.equals(Clock.systemUTC())) {
            throw new IllegalStateException("You need to use setMockClock() first.");
        }
        TimeUtils.setMockClock(clock.instant().plus(delta));
    }

    public static void clearMockClock() {
        clock = Clock.systemUTC();
    }

    public static Instant currentTime() {
        return Instant.now(clock);
    }

    public static Duration elapsedTime(Instant start) {
        return Duration.between(start, TimeUtils.currentTime());
    }

    public static Instant earlier(Instant time1, Instant time2) {
        return time1.isBefore(time2) ? time1 : time2;
    }

    public static Instant later(Instant time1, Instant time2) {
        return time1.isAfter(time2) ? time1 : time2;
    }

    public static Duration longest(Duration duration1, Duration duration2) {
        return duration1.compareTo(duration2) > 0 ? duration1 : duration2;
    }

    public static String dateTimeFormat(Instant time) {
        return DateTimeFormatter.ISO_INSTANT.format(time);
    }
}

