/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.base.utils;

import java.math.BigDecimal;
import java.util.Objects;
import org.bitcoinj.base.Monetary;
import org.bitcoinj.base.internal.Preconditions;
import org.bitcoinj.base.utils.MonetaryFormat;

public final class Fiat
implements Monetary,
Comparable<Fiat> {
    public static final int SMALLEST_UNIT_EXPONENT = 4;
    public final long value;
    public final String currencyCode;
    private static final MonetaryFormat FRIENDLY_FORMAT = MonetaryFormat.FIAT.postfixCode();
    private static final MonetaryFormat PLAIN_FORMAT = MonetaryFormat.FIAT.minDecimals(0).repeatOptionalDecimals(1, 4).noCode();

    private Fiat(String currencyCode, long value) {
        this.value = value;
        this.currencyCode = currencyCode;
    }

    public static Fiat valueOf(String currencyCode, long value) {
        return new Fiat(currencyCode, value);
    }

    @Override
    public int smallestUnitExponent() {
        return 4;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public static Fiat parseFiat(String currencyCode, String str) {
        try {
            long val = new BigDecimal(str).movePointRight(4).longValueExact();
            return Fiat.valueOf(currencyCode, val);
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Fiat parseFiatInexact(String currencyCode, String str) {
        try {
            long val = new BigDecimal(str).movePointRight(4).longValue();
            return Fiat.valueOf(currencyCode, val);
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Fiat add(Fiat value) {
        Preconditions.checkArgument(value.currencyCode.equals(this.currencyCode), () -> "values to add must be of same currency: " + value.currencyCode + " vs " + this.currencyCode);
        return new Fiat(this.currencyCode, Math.addExact(this.value, value.value));
    }

    public Fiat subtract(Fiat value) {
        Preconditions.checkArgument(value.currencyCode.equals(this.currencyCode), () -> "values to substract must be of same currency: " + value.currencyCode + " vs " + this.currencyCode);
        return new Fiat(this.currencyCode, Math.subtractExact(this.value, value.value));
    }

    public Fiat multiply(long factor) {
        return new Fiat(this.currencyCode, Math.multiplyExact(this.value, factor));
    }

    public Fiat divide(long divisor) {
        return new Fiat(this.currencyCode, this.value / divisor);
    }

    public Fiat[] divideAndRemainder(long divisor) {
        return new Fiat[]{new Fiat(this.currencyCode, this.value / divisor), new Fiat(this.currencyCode, this.value % divisor)};
    }

    public long divide(Fiat divisor) {
        Preconditions.checkArgument(divisor.currencyCode.equals(this.currencyCode), () -> "values to divide must be of same currency: " + divisor.currencyCode + " vs " + this.currencyCode);
        return this.value / divisor.value;
    }

    public boolean isPositive() {
        return this.signum() == 1;
    }

    public boolean isNegative() {
        return this.signum() == -1;
    }

    public boolean isZero() {
        return this.signum() == 0;
    }

    public boolean isGreaterThan(Fiat other) {
        return this.compareTo(other) > 0;
    }

    public boolean isLessThan(Fiat other) {
        return this.compareTo(other) < 0;
    }

    @Override
    public int signum() {
        if (this.value == 0L) {
            return 0;
        }
        return this.value < 0L ? -1 : 1;
    }

    public Fiat negate() {
        return new Fiat(this.currencyCode, -this.value);
    }

    public long longValue() {
        return this.value;
    }

    public String toFriendlyString() {
        return FRIENDLY_FORMAT.code(0, this.currencyCode).format(this).toString();
    }

    public String toPlainString() {
        return PLAIN_FORMAT.format(this).toString();
    }

    public String toString() {
        return Long.toString(this.value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Fiat other = (Fiat)o;
        return this.value == other.value && this.currencyCode.equals(other.currencyCode);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.currencyCode);
    }

    @Override
    public int compareTo(Fiat other) {
        if (!this.currencyCode.equals(other.currencyCode)) {
            return this.currencyCode.compareTo(other.currencyCode);
        }
        return Long.compare(this.value, other.value);
    }
}

