/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.base.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.bitcoinj.base.Coin;
import org.bitcoinj.base.Monetary;
import org.bitcoinj.base.internal.Preconditions;
import org.bitcoinj.base.utils.Fiat;

public final class MonetaryFormat {
    public static final MonetaryFormat BTC = new MonetaryFormat().shift(0).minDecimals(2).repeatOptionalDecimals(2, 3);
    public static final MonetaryFormat MBTC = new MonetaryFormat().shift(3).minDecimals(2).optionalDecimals(2);
    public static final MonetaryFormat UBTC = new MonetaryFormat().shift(6).minDecimals(0).optionalDecimals(2);
    public static final MonetaryFormat SAT = new MonetaryFormat().shift(8).minDecimals(0).optionalDecimals(0);
    public static final MonetaryFormat FIAT = new MonetaryFormat().shift(0).minDecimals(2).repeatOptionalDecimals(2, 1);
    public static final String CODE_BTC = "BTC";
    public static final String CODE_MBTC = "mBTC";
    public static final String CODE_UBTC = "\u00b5BTC";
    public static final String CODE_SAT = "sat";
    public static final String SYMBOL_BTC = "\u20bf";
    public static final String SYMBOL_MBTC = "m\u20bf";
    public static final String SYMBOL_UBTC = "\u00b5\u20bf";
    public static final String SYMBOL_SAT = "\u0219";
    public static final int MAX_DECIMALS = 8;
    private final char negativeSign;
    private final char positiveSign;
    private final char zeroDigit;
    private final char decimalMark;
    private final int minDecimals;
    private final List<Integer> decimalGroups;
    private final int shift;
    private final RoundingMode roundingMode;
    private final String[] codes;
    private final char codeSeparator;
    private final boolean codePrefixed;
    private static final String DECIMALS_PADDING = "0000000000000000";

    public MonetaryFormat negativeSign(char negativeSign) {
        Preconditions.checkArgument(!Character.isDigit(negativeSign), () -> "negativeSign can't be digit: " + negativeSign);
        Preconditions.checkArgument(negativeSign > '\u0000', () -> "negativeSign must be positive: " + negativeSign);
        if (negativeSign == this.negativeSign) {
            return this;
        }
        return new MonetaryFormat(negativeSign, this.positiveSign, this.zeroDigit, this.decimalMark, this.minDecimals, this.decimalGroups, this.shift, this.roundingMode, this.codes, this.codeSeparator, this.codePrefixed);
    }

    public MonetaryFormat positiveSign(char positiveSign) {
        Preconditions.checkArgument(!Character.isDigit(positiveSign), () -> "positiveSign can't be digit: " + positiveSign);
        if (positiveSign == this.positiveSign) {
            return this;
        }
        return new MonetaryFormat(this.negativeSign, positiveSign, this.zeroDigit, this.decimalMark, this.minDecimals, this.decimalGroups, this.shift, this.roundingMode, this.codes, this.codeSeparator, this.codePrefixed);
    }

    public MonetaryFormat digits(char zeroDigit) {
        if (zeroDigit == this.zeroDigit) {
            return this;
        }
        return new MonetaryFormat(this.negativeSign, this.positiveSign, zeroDigit, this.decimalMark, this.minDecimals, this.decimalGroups, this.shift, this.roundingMode, this.codes, this.codeSeparator, this.codePrefixed);
    }

    public MonetaryFormat decimalMark(char decimalMark) {
        Preconditions.checkArgument(!Character.isDigit(decimalMark), () -> "decimalMark can't be digit: " + decimalMark);
        Preconditions.checkArgument(decimalMark > '\u0000', () -> "decimalMark must be positive: " + decimalMark);
        if (decimalMark == this.decimalMark) {
            return this;
        }
        return new MonetaryFormat(this.negativeSign, this.positiveSign, this.zeroDigit, decimalMark, this.minDecimals, this.decimalGroups, this.shift, this.roundingMode, this.codes, this.codeSeparator, this.codePrefixed);
    }

    public MonetaryFormat minDecimals(int minDecimals) {
        if (minDecimals == this.minDecimals) {
            return this;
        }
        return new MonetaryFormat(this.negativeSign, this.positiveSign, this.zeroDigit, this.decimalMark, minDecimals, this.decimalGroups, this.shift, this.roundingMode, this.codes, this.codeSeparator, this.codePrefixed);
    }

    public MonetaryFormat optionalDecimals(int ... groups2) {
        ArrayList<Integer> decimalGroups = new ArrayList<Integer>(groups2.length);
        for (int group : groups2) {
            decimalGroups.add(group);
        }
        return new MonetaryFormat(this.negativeSign, this.positiveSign, this.zeroDigit, this.decimalMark, this.minDecimals, decimalGroups, this.shift, this.roundingMode, this.codes, this.codeSeparator, this.codePrefixed);
    }

    public MonetaryFormat repeatOptionalDecimals(int decimals, int repetitions) {
        Preconditions.checkArgument(repetitions >= 0, () -> "repetitions cannot be negative: " + repetitions);
        ArrayList<Integer> decimalGroups = new ArrayList<Integer>(repetitions);
        for (int i2 = 0; i2 < repetitions; ++i2) {
            decimalGroups.add(decimals);
        }
        return new MonetaryFormat(this.negativeSign, this.positiveSign, this.zeroDigit, this.decimalMark, this.minDecimals, decimalGroups, this.shift, this.roundingMode, this.codes, this.codeSeparator, this.codePrefixed);
    }

    public MonetaryFormat shift(int shift) {
        if (shift == this.shift) {
            return this;
        }
        return new MonetaryFormat(this.negativeSign, this.positiveSign, this.zeroDigit, this.decimalMark, this.minDecimals, this.decimalGroups, shift, this.roundingMode, this.codes, this.codeSeparator, this.codePrefixed);
    }

    public MonetaryFormat roundingMode(RoundingMode roundingMode) {
        if (roundingMode == this.roundingMode) {
            return this;
        }
        return new MonetaryFormat(this.negativeSign, this.positiveSign, this.zeroDigit, this.decimalMark, this.minDecimals, this.decimalGroups, this.shift, roundingMode, this.codes, this.codeSeparator, this.codePrefixed);
    }

    public MonetaryFormat noCode() {
        if (this.codes == null) {
            return this;
        }
        return new MonetaryFormat(this.negativeSign, this.positiveSign, this.zeroDigit, this.decimalMark, this.minDecimals, this.decimalGroups, this.shift, this.roundingMode, null, this.codeSeparator, this.codePrefixed);
    }

    public MonetaryFormat code(int codeShift, String code) {
        Preconditions.checkArgument(codeShift >= 0, () -> "codeShift cannot be negative: " + codeShift);
        String[] codes = null == this.codes ? new String[8] : Arrays.copyOf(this.codes, this.codes.length);
        codes[codeShift] = code;
        return new MonetaryFormat(this.negativeSign, this.positiveSign, this.zeroDigit, this.decimalMark, this.minDecimals, this.decimalGroups, this.shift, this.roundingMode, codes, this.codeSeparator, this.codePrefixed);
    }

    public MonetaryFormat codeSeparator(char codeSeparator) {
        Preconditions.checkArgument(!Character.isDigit(codeSeparator), () -> "codeSeparator can't be digit: " + codeSeparator);
        Preconditions.checkArgument(codeSeparator > '\u0000', () -> "codeSeparator must be positive: " + codeSeparator);
        if (codeSeparator == this.codeSeparator) {
            return this;
        }
        return new MonetaryFormat(this.negativeSign, this.positiveSign, this.zeroDigit, this.decimalMark, this.minDecimals, this.decimalGroups, this.shift, this.roundingMode, this.codes, codeSeparator, this.codePrefixed);
    }

    public MonetaryFormat prefixCode() {
        if (this.codePrefixed) {
            return this;
        }
        return new MonetaryFormat(this.negativeSign, this.positiveSign, this.zeroDigit, this.decimalMark, this.minDecimals, this.decimalGroups, this.shift, this.roundingMode, this.codes, this.codeSeparator, true);
    }

    public MonetaryFormat postfixCode() {
        if (!this.codePrefixed) {
            return this;
        }
        return new MonetaryFormat(this.negativeSign, this.positiveSign, this.zeroDigit, this.decimalMark, this.minDecimals, this.decimalGroups, this.shift, this.roundingMode, this.codes, this.codeSeparator, false);
    }

    public MonetaryFormat withLocale(Locale locale) {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(locale);
        char negativeSign = dfs.getMinusSign();
        char zeroDigit = dfs.getZeroDigit();
        char decimalMark = dfs.getMonetaryDecimalSeparator();
        return new MonetaryFormat(negativeSign, this.positiveSign, zeroDigit, decimalMark, this.minDecimals, this.decimalGroups, this.shift, this.roundingMode, this.codes, this.codeSeparator, this.codePrefixed);
    }

    public MonetaryFormat() {
        this(false);
    }

    public MonetaryFormat(boolean useSymbol) {
        this.negativeSign = (char)45;
        this.positiveSign = '\u0000';
        this.zeroDigit = (char)48;
        this.decimalMark = (char)46;
        this.minDecimals = 2;
        this.decimalGroups = null;
        this.shift = 0;
        this.roundingMode = RoundingMode.HALF_UP;
        this.codes = new String[9];
        this.codes[0] = useSymbol ? SYMBOL_BTC : CODE_BTC;
        this.codes[3] = useSymbol ? SYMBOL_MBTC : CODE_MBTC;
        this.codes[6] = useSymbol ? SYMBOL_UBTC : CODE_UBTC;
        this.codes[8] = useSymbol ? SYMBOL_SAT : CODE_SAT;
        this.codeSeparator = (char)32;
        this.codePrefixed = true;
    }

    private MonetaryFormat(char negativeSign, char positiveSign, char zeroDigit, char decimalMark, int minDecimals, List<Integer> decimalGroups, int shift, RoundingMode roundingMode, String[] codes, char codeSeparator, boolean codePrefixed) {
        this.negativeSign = negativeSign;
        this.positiveSign = positiveSign;
        this.zeroDigit = zeroDigit;
        this.decimalMark = decimalMark;
        this.minDecimals = minDecimals;
        this.decimalGroups = decimalGroups;
        this.shift = shift;
        this.roundingMode = roundingMode;
        this.codes = codes;
        this.codeSeparator = codeSeparator;
        this.codePrefixed = codePrefixed;
    }

    public CharSequence format(Monetary monetary) {
        int smallestUnitExponent;
        int maxVisibleDecimals;
        int max = this.minDecimals;
        if (this.decimalGroups != null) {
            for (int group : this.decimalGroups) {
                max += group;
            }
        }
        Preconditions.checkState((maxVisibleDecimals = max) <= (smallestUnitExponent = monetary.smallestUnitExponent()), () -> "maxVisibleDecimals cannot exceed " + smallestUnitExponent + ": " + maxVisibleDecimals);
        long satoshis = Math.abs(monetary.getValue());
        int decimalShift = smallestUnitExponent - this.shift;
        DecimalNumber decimal = MonetaryFormat.satoshisToDecimal(satoshis, this.roundingMode, decimalShift, maxVisibleDecimals);
        long numbers = decimal.numbers;
        long decimals = decimal.decimals;
        String decimalsStr = decimalShift > 0 ? String.format(Locale.US, "%0" + Integer.toString(decimalShift) + "d", decimals) : "";
        StringBuilder str = new StringBuilder(decimalsStr);
        while (str.length() > this.minDecimals && str.charAt(str.length() - 1) == '0') {
            str.setLength(str.length() - 1);
        }
        int i2 = this.minDecimals;
        if (this.decimalGroups != null) {
            for (int group : this.decimalGroups) {
                if (str.length() > i2 && str.length() < i2 + group) {
                    while (str.length() < i2 + group) {
                        str.append('0');
                    }
                    break;
                }
                i2 += group;
            }
        }
        if (str.length() > 0) {
            str.insert(0, this.decimalMark);
        }
        str.insert(0, numbers);
        if (monetary.getValue() < 0L) {
            str.insert(0, this.negativeSign);
        } else if (this.positiveSign != '\u0000') {
            str.insert(0, this.positiveSign);
        }
        if (this.codes != null) {
            if (this.codePrefixed) {
                str.insert(0, this.codeSeparator);
                str.insert(0, this.code());
            } else {
                str.append(this.codeSeparator);
                str.append(this.code());
            }
        }
        if (this.zeroDigit != '0') {
            int offset = this.zeroDigit - 48;
            for (int d = 0; d < str.length(); ++d) {
                char c = str.charAt(d);
                if (!Character.isDigit(c)) continue;
                str.setCharAt(d, (char)(c + offset));
            }
        }
        return str;
    }

    private static DecimalNumber satoshisToDecimal(long satoshis, RoundingMode roundingMode, int decimalShift, int maxVisibleDecimals) {
        BigDecimal decimalSats = BigDecimal.valueOf(satoshis);
        decimalSats = decimalSats.movePointLeft(decimalShift);
        decimalSats = decimalSats.setScale(maxVisibleDecimals, roundingMode);
        BigDecimal[] separated = decimalSats.divideAndRemainder(BigDecimal.ONE);
        return new DecimalNumber(separated[0].longValue(), separated[1].movePointRight(decimalShift).longValue());
    }

    public Coin parse(String str) throws NumberFormatException {
        return Coin.valueOf(this.parseValue(str, 8));
    }

    public Fiat parseFiat(String currencyCode, String str) throws NumberFormatException {
        return Fiat.valueOf(currencyCode, this.parseValue(str, 4));
    }

    private long parseValue(String str, int smallestUnitExponent) {
        String decimals;
        String numbers;
        int decimalMarkIndex;
        Preconditions.checkState(DECIMALS_PADDING.length() >= smallestUnitExponent, () -> "smallestUnitExponent can't be higher than " + DECIMALS_PADDING.length() + ": " + smallestUnitExponent);
        if (str.isEmpty()) {
            throw new NumberFormatException("empty string");
        }
        char first = str.charAt(0);
        if (first == this.negativeSign || first == this.positiveSign) {
            str = str.substring(1);
        }
        if ((decimalMarkIndex = str.indexOf(this.decimalMark)) != -1) {
            numbers = str.substring(0, decimalMarkIndex);
            decimals = (str + DECIMALS_PADDING).substring(decimalMarkIndex + 1);
            if (decimals.indexOf(this.decimalMark) != -1) {
                throw new NumberFormatException("more than one decimal mark");
            }
        } else {
            numbers = str;
            decimals = DECIMALS_PADDING;
        }
        String satoshis = numbers + decimals.substring(0, smallestUnitExponent - this.shift);
        for (char c : satoshis.toCharArray()) {
            if (Character.isDigit(c)) continue;
            throw new NumberFormatException("illegal character: " + c);
        }
        long value = Long.parseLong(satoshis);
        if (first == this.negativeSign) {
            value = -value;
        }
        return value;
    }

    public String code() {
        if (this.codes == null) {
            return null;
        }
        if (this.codes[this.shift] == null) {
            throw new NumberFormatException("missing code for shift: " + this.shift);
        }
        return this.codes[this.shift];
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        MonetaryFormat other = (MonetaryFormat)o;
        if (!Objects.equals(Character.valueOf(this.negativeSign), Character.valueOf(other.negativeSign))) {
            return false;
        }
        if (!Objects.equals(Character.valueOf(this.positiveSign), Character.valueOf(other.positiveSign))) {
            return false;
        }
        if (!Objects.equals(Character.valueOf(this.zeroDigit), Character.valueOf(other.zeroDigit))) {
            return false;
        }
        if (!Objects.equals(Character.valueOf(this.decimalMark), Character.valueOf(other.decimalMark))) {
            return false;
        }
        if (!Objects.equals(this.minDecimals, other.minDecimals)) {
            return false;
        }
        if (!Objects.equals(this.decimalGroups, other.decimalGroups)) {
            return false;
        }
        if (!Objects.equals(this.shift, other.shift)) {
            return false;
        }
        if (!Objects.equals((Object)this.roundingMode, (Object)other.roundingMode)) {
            return false;
        }
        if (!Arrays.equals(this.codes, other.codes)) {
            return false;
        }
        if (!Objects.equals(Character.valueOf(this.codeSeparator), Character.valueOf(other.codeSeparator))) {
            return false;
        }
        return Objects.equals(this.codePrefixed, other.codePrefixed);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{Character.valueOf(this.negativeSign), Character.valueOf(this.positiveSign), Character.valueOf(this.zeroDigit), Character.valueOf(this.decimalMark), this.minDecimals, this.decimalGroups, this.shift, this.roundingMode, Arrays.hashCode(this.codes), Character.valueOf(this.codeSeparator), this.codePrefixed});
    }

    private static class DecimalNumber {
        final long numbers;
        final long decimals;

        private DecimalNumber(long numbers, long decimals) {
            this.numbers = numbers;
            this.decimals = decimals;
        }
    }
}

