/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bitcoinj.base.VarInt;
import org.bitcoinj.base.internal.Preconditions;
import org.bitcoinj.core.BaseMessage;
import org.bitcoinj.core.PeerAddress;
import org.bitcoinj.core.ProtocolException;

public abstract class AddressMessage
extends BaseMessage {
    protected static final long MAX_ADDRESSES = 1000L;
    protected List<PeerAddress> addresses;

    protected static List<PeerAddress> readAddresses(ByteBuffer payload, int protocolVariant) throws BufferUnderflowException, ProtocolException {
        VarInt numAddressesVarInt = VarInt.read(payload);
        Preconditions.check(numAddressesVarInt.fitsInt(), BufferUnderflowException::new);
        int numAddresses = numAddressesVarInt.intValue();
        if ((long)numAddresses > 1000L) {
            throw new ProtocolException("Address message too large.");
        }
        ArrayList<PeerAddress> addresses = new ArrayList<PeerAddress>(numAddresses);
        for (int i2 = 0; i2 < numAddresses; ++i2) {
            addresses.add(PeerAddress.read(payload, protocolVariant));
        }
        return addresses;
    }

    protected AddressMessage(List<PeerAddress> addresses) {
        this.addresses = addresses;
    }

    public abstract void addAddress(PeerAddress var1);

    public void removeAddress(int index) {
        PeerAddress address = this.addresses.remove(index);
    }

    public List<PeerAddress> getAddresses() {
        return Collections.unmodifiableList(this.addresses);
    }
}

