/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.List;
import org.bitcoinj.base.VarInt;
import org.bitcoinj.base.internal.InternalUtils;
import org.bitcoinj.core.AddressMessage;
import org.bitcoinj.core.PeerAddress;
import org.bitcoinj.core.ProtocolException;

public class AddressV2Message
extends AddressMessage {
    public static AddressV2Message read(ByteBuffer payload) throws BufferUnderflowException, ProtocolException {
        return new AddressV2Message(AddressV2Message.readAddresses(payload, 2));
    }

    private AddressV2Message(List<PeerAddress> addresses) {
        super(addresses);
    }

    @Override
    public void addAddress(PeerAddress address) {
        this.addresses.add(address);
    }

    @Override
    protected void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        if (this.addresses == null) {
            return;
        }
        stream.write(VarInt.of(this.addresses.size()).serialize());
        for (PeerAddress addr : this.addresses) {
            stream.write(addr.serialize(2));
        }
    }

    public String toString() {
        return "addrv2: " + InternalUtils.SPACE_JOINER.join(this.addresses);
    }
}

