/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.bitcoinj.base.Network;
import org.bitcoinj.base.Sha256Hash;
import org.bitcoinj.base.internal.ByteUtils;
import org.bitcoinj.base.internal.Preconditions;
import org.bitcoinj.core.AddressV1Message;
import org.bitcoinj.core.AddressV2Message;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.BloomFilter;
import org.bitcoinj.core.FeeFilterMessage;
import org.bitcoinj.core.FilteredBlock;
import org.bitcoinj.core.GetAddrMessage;
import org.bitcoinj.core.GetBlocksMessage;
import org.bitcoinj.core.GetDataMessage;
import org.bitcoinj.core.GetHeadersMessage;
import org.bitcoinj.core.HeadersMessage;
import org.bitcoinj.core.InventoryMessage;
import org.bitcoinj.core.MemoryPoolMessage;
import org.bitcoinj.core.Message;
import org.bitcoinj.core.MessageSerializer;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.NotFoundMessage;
import org.bitcoinj.core.Ping;
import org.bitcoinj.core.Pong;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.core.ProtocolVersion;
import org.bitcoinj.core.RejectMessage;
import org.bitcoinj.core.SendAddrV2Message;
import org.bitcoinj.core.SendHeadersMessage;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.UnknownMessage;
import org.bitcoinj.core.VersionAck;
import org.bitcoinj.core.VersionMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitcoinSerializer
extends MessageSerializer {
    private static final Logger log = LoggerFactory.getLogger(BitcoinSerializer.class);
    private static final int COMMAND_LEN = 12;
    private final Network network;
    private final int packetMagic;
    private final int protocolVersion;
    private static final Map<Class<? extends Message>, String> names = new HashMap<Class<? extends Message>, String>();

    @Deprecated
    public BitcoinSerializer(NetworkParameters params) {
        this(params.network());
    }

    public BitcoinSerializer(Network network) {
        this(network, ProtocolVersion.CURRENT.intValue());
    }

    @Deprecated
    public BitcoinSerializer(NetworkParameters params, int protocolVersion) {
        this(params.network, protocolVersion);
    }

    public BitcoinSerializer(Network network, int protocolVersion) {
        this.network = network;
        this.packetMagic = NetworkParameters.of(network).getPacketMagic();
        this.protocolVersion = protocolVersion;
    }

    @Override
    public BitcoinSerializer withProtocolVersion(int protocolVersion) {
        return protocolVersion == this.protocolVersion ? this : new BitcoinSerializer(this.network, protocolVersion);
    }

    @Override
    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public void serialize(String name, byte[] message, OutputStream out) throws IOException {
        byte[] header = new byte[24];
        ByteUtils.writeInt32BE(this.packetMagic, header, 0);
        for (int i2 = 0; i2 < name.length() && i2 < 12; ++i2) {
            header[4 + i2] = (byte)(name.codePointAt(i2) & 0xFF);
        }
        ByteUtils.writeInt32LE(message.length, header, 16);
        byte[] hash = Sha256Hash.hashTwice(message);
        System.arraycopy(hash, 0, header, 20, 4);
        out.write(header);
        out.write(message);
        if (log.isDebugEnabled()) {
            log.debug("Sending {} message: {}", (Object)name, (Object)(ByteUtils.formatHex(header) + ByteUtils.formatHex(message)));
        }
    }

    @Override
    public void serialize(Message message, OutputStream out) throws IOException {
        String name = names.get(message.getClass());
        if (name == null) {
            throw new Error("BitcoinSerializer doesn't currently know how to serialize " + message.getClass());
        }
        this.serialize(name, message.serialize(), out);
    }

    @Override
    public Message deserialize(ByteBuffer in) throws ProtocolException, IOException {
        this.seekPastMagicBytes(in);
        BitcoinPacketHeader header = new BitcoinPacketHeader(in);
        return this.deserializePayload(header, in);
    }

    @Override
    public BitcoinPacketHeader deserializeHeader(ByteBuffer in) throws ProtocolException, IOException {
        return new BitcoinPacketHeader(in);
    }

    @Override
    public Message deserializePayload(BitcoinPacketHeader header, ByteBuffer in) throws ProtocolException, BufferUnderflowException {
        byte[] payloadBytes = new byte[header.size];
        in.get(payloadBytes, 0, header.size);
        byte[] hash = Sha256Hash.hashTwice(payloadBytes);
        if (header.checksum[0] != hash[0] || header.checksum[1] != hash[1] || header.checksum[2] != hash[2] || header.checksum[3] != hash[3]) {
            throw new ProtocolException("Checksum failed to verify, actual " + ByteUtils.formatHex(hash) + " vs " + ByteUtils.formatHex(header.checksum));
        }
        if (log.isDebugEnabled()) {
            log.debug("Received {} byte '{}' message: {}", header.size, header.command, ByteUtils.formatHex(payloadBytes));
        }
        try {
            return this.makeMessage(header.command, payloadBytes, hash);
        }
        catch (Exception e) {
            throw new ProtocolException("Error deserializing message " + ByteUtils.formatHex(payloadBytes) + "\n", e);
        }
    }

    private Message makeMessage(String command, byte[] payloadBytes, byte[] hash) throws ProtocolException {
        ByteBuffer payload = ByteBuffer.wrap(payloadBytes);
        if (command.equals("version")) {
            return VersionMessage.read(payload);
        }
        if (command.equals("inv")) {
            return this.makeInventoryMessage(payload);
        }
        if (command.equals("block")) {
            return this.makeBlock(payload);
        }
        if (command.equals("merkleblock")) {
            return this.makeFilteredBlock(payload);
        }
        if (command.equals("getdata")) {
            return GetDataMessage.read(payload);
        }
        if (command.equals("getblocks")) {
            return GetBlocksMessage.read(payload);
        }
        if (command.equals("getheaders")) {
            return GetHeadersMessage.read(payload);
        }
        if (command.equals("tx")) {
            return this.makeTransaction(payload);
        }
        if (command.equals("sendaddrv2")) {
            Preconditions.check(!payload.hasRemaining(), ProtocolException::new);
            return new SendAddrV2Message();
        }
        if (command.equals("addr")) {
            return this.makeAddressV1Message(payload);
        }
        if (command.equals("addrv2")) {
            return this.makeAddressV2Message(payload);
        }
        if (command.equals("ping")) {
            return Ping.read(payload);
        }
        if (command.equals("pong")) {
            return Pong.read(payload);
        }
        if (command.equals("verack")) {
            Preconditions.check(!payload.hasRemaining(), ProtocolException::new);
            return new VersionAck();
        }
        if (command.equals("headers")) {
            return HeadersMessage.read(payload);
        }
        if (command.equals("filterload")) {
            return this.makeBloomFilter(payload);
        }
        if (command.equals("notfound")) {
            return NotFoundMessage.read(payload);
        }
        if (command.equals("mempool")) {
            return new MemoryPoolMessage();
        }
        if (command.equals("reject")) {
            return RejectMessage.read(payload);
        }
        if (command.equals("sendheaders")) {
            Preconditions.check(!payload.hasRemaining(), ProtocolException::new);
            return new SendHeadersMessage();
        }
        if (command.equals("feefilter")) {
            return FeeFilterMessage.read(payload);
        }
        Preconditions.check(!payload.hasRemaining(), ProtocolException::new);
        return new UnknownMessage(command);
    }

    @Deprecated
    public NetworkParameters getParameters() {
        return NetworkParameters.of(this.network);
    }

    @Override
    public AddressV1Message makeAddressV1Message(ByteBuffer payload) throws ProtocolException {
        return AddressV1Message.read(payload);
    }

    @Override
    public AddressV2Message makeAddressV2Message(ByteBuffer payload) throws ProtocolException {
        return AddressV2Message.read(payload);
    }

    @Override
    public Block makeBlock(ByteBuffer payload) throws ProtocolException {
        return Block.read(payload);
    }

    @Override
    public Message makeBloomFilter(ByteBuffer payload) throws ProtocolException {
        return BloomFilter.read(payload);
    }

    @Override
    public FilteredBlock makeFilteredBlock(ByteBuffer payload) throws ProtocolException {
        return FilteredBlock.read(payload);
    }

    @Override
    public InventoryMessage makeInventoryMessage(ByteBuffer payload) throws ProtocolException {
        return InventoryMessage.read(payload);
    }

    @Override
    public Transaction makeTransaction(ByteBuffer payload) throws ProtocolException {
        return Transaction.read(payload, this.protocolVersion);
    }

    @Override
    public void seekPastMagicBytes(ByteBuffer in) throws BufferUnderflowException {
        int magicCursor = 3;
        while (true) {
            byte expectedByte;
            byte b;
            if ((b = in.get()) == (expectedByte = (byte)(0xFF & this.packetMagic >>> magicCursor * 8))) {
                if (--magicCursor >= 0) continue;
                return;
            }
            magicCursor = 3;
        }
    }

    static {
        names.put(VersionMessage.class, "version");
        names.put(InventoryMessage.class, "inv");
        names.put(Block.class, "block");
        names.put(GetDataMessage.class, "getdata");
        names.put(Transaction.class, "tx");
        names.put(AddressV1Message.class, "addr");
        names.put(AddressV2Message.class, "addrv2");
        names.put(Ping.class, "ping");
        names.put(Pong.class, "pong");
        names.put(VersionAck.class, "verack");
        names.put(GetBlocksMessage.class, "getblocks");
        names.put(GetHeadersMessage.class, "getheaders");
        names.put(GetAddrMessage.class, "getaddr");
        names.put(SendAddrV2Message.class, "sendaddrv2");
        names.put(HeadersMessage.class, "headers");
        names.put(BloomFilter.class, "filterload");
        names.put(FilteredBlock.class, "merkleblock");
        names.put(NotFoundMessage.class, "notfound");
        names.put(MemoryPoolMessage.class, "mempool");
        names.put(RejectMessage.class, "reject");
        names.put(SendHeadersMessage.class, "sendheaders");
        names.put(FeeFilterMessage.class, "feefilter");
    }

    public static class BitcoinPacketHeader {
        public static final int HEADER_LENGTH = 20;
        public final byte[] header = new byte[20];
        public final String command;
        public final int size;
        public final byte[] checksum;

        public BitcoinPacketHeader(ByteBuffer in) throws ProtocolException, BufferUnderflowException {
            int cursor;
            in.get(this.header, 0, this.header.length);
            for (cursor = 0; this.header[cursor] != 0 && cursor < 12; ++cursor) {
            }
            byte[] commandBytes = new byte[cursor];
            System.arraycopy(this.header, 0, commandBytes, 0, cursor);
            this.command = new String(commandBytes, StandardCharsets.US_ASCII);
            cursor = 12;
            this.size = (int)ByteUtils.readUint32(this.header, cursor);
            cursor += 4;
            if (this.size > 0x2000000 || this.size < 0) {
                throw new ProtocolException("Message size too large: " + this.size);
            }
            this.checksum = new byte[4];
            System.arraycopy(this.header, cursor, this.checksum, 0, 4);
        }
    }
}

